/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import java.io.IOException;
import lux.Evaluator;
import lux.functions.SearchBase;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.apache.lucene.document.Document;

public class FieldValues
extends ExtensionFunctionDefinition {
    public StructuredQName getFunctionQName() {
        return new StructuredQName("lux", "http://luxdb.net", "field-values");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.OPTIONAL_NODE};
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public boolean trustResultType() {
        return true;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ATOMIC_SEQUENCE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new FieldValuesCall();
    }

    class FieldValuesCall
    extends ExtensionFunctionCall {
        FieldValuesCall() {
        }

        public SequenceIterator<? extends Item> call(SequenceIterator<? extends Item>[] arguments, XPathContext context) throws XPathException {
            Document doc;
            NodeInfo node;
            String fieldName = arguments[0].next().getStringValue();
            if (arguments.length == 1) {
                Item contextItem = context.getContextItem();
                if (!(contextItem instanceof NodeInfo)) {
                    throw new XPathException("Call to lux:field-values($field-name) depends on context, but there is no context defined");
                }
                node = (NodeInfo)contextItem;
            } else {
                node = (NodeInfo)arguments[1].next();
            }
            if (node == null) {
                return EmptySequence.asIterator((ValueRepresentation)EmptySequence.getInstance());
            }
            long docID = node.getDocumentNumber();
            Evaluator eval = SearchBase.getEvaluator(context);
            try {
                doc = eval.getSearcher().doc((int)docID);
            }
            catch (IOException e) {
                throw new XPathException((Throwable)e);
            }
            String[] values = doc.getValues(fieldName);
            StringValue[] valueItems = new StringValue[values.length];
            int i = 0;
            while (i < values.length) {
                valueItems[i] = new StringValue((CharSequence)values[i]);
                ++i;
            }
            return new ArrayIterator((Item[])valueItems);
        }
    }
}

