/*
 * Decompiled with CFR 0.152.
 */
package lux.index;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import lux.index.XmlPathMapper;

public class QNameTextMapper
extends XmlPathMapper {
    private int depth = -1;
    private StringBuilder[] stack = new StringBuilder[8];
    private ArrayList<String> names = new ArrayList();
    private ArrayList<String> values = new ArrayList();

    public QNameTextMapper() {
        int i = 0;
        while (i < this.stack.length) {
            this.stack[i] = new StringBuilder();
            ++i;
        }
    }

    public ArrayList<String> getValues() {
        return this.values;
    }

    public ArrayList<String> getNames() {
        return this.names;
    }

    @Override
    public void reset() {
        super.reset();
        this.depth = -1;
        this.names.clear();
        this.values.clear();
    }

    @Override
    public void handleEvent(XMLStreamReader reader, int eventType) {
        switch (eventType) {
            case 7: {
                super.handleEvent(reader, eventType);
                break;
            }
            case 1: {
                super.handleEvent(reader, eventType);
                StringBuilder buf = this.pushStackFrame();
                int i = 0;
                while (i < reader.getAttributeCount()) {
                    QName attQName = this.getEventAttQName(reader, i);
                    String name = String.valueOf('@') + this.encodeQName(attQName);
                    this.names.add(name);
                    buf.append(reader.getAttributeValue(i));
                    this.values.add(buf.toString());
                    buf.setLength(0);
                    ++i;
                }
                break;
            }
            case 2: {
                super.handleEvent(reader, eventType);
                StringBuilder buf = this.popStackFrame();
                this.names.add(this.encodeQName(this.currentQName));
                this.values.add(buf.toString());
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                this.stack[this.depth].append(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                super.handleEvent(reader, eventType);
                break;
            }
            case 9: {
                this.stack[this.depth].append(reader.getText());
                break;
            }
            default: {
                super.handleEvent(reader, eventType);
            }
        }
    }

    private StringBuilder popStackFrame() {
        return this.stack[this.depth--];
    }

    private StringBuilder pushStackFrame() {
        if (this.depth++ >= this.stack.length) {
            this.growStack();
        } else {
            this.stack[this.depth].setLength(0);
        }
        return this.stack[this.depth];
    }

    private void growStack() {
        this.stack = Arrays.copyOf(this.stack, this.stack.length + 8);
    }
}

