/*
 * Decompiled with CFR 0.152.
 */
package lux.index;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import lux.index.XmlPathMapper;

public class XPathValueMapper
extends XmlPathMapper {
    public static final int HASH_SIZE = 8;
    int depth;
    int[] valueOffsets = new int[16];
    char[][] values = new char[16][8];
    char[] attValue = new char[8];
    private ArrayList<char[]> pathValues = new ArrayList();

    public ArrayList<char[]> getPathValues() {
        return this.pathValues;
    }

    @Override
    public void reset() {
        super.reset();
        this.pathValues.clear();
    }

    @Override
    public void handleEvent(XMLStreamReader reader, int eventType) {
        switch (eventType) {
            case 7: {
                this.depth = -1;
                super.handleEvent(reader, eventType);
                break;
            }
            case 1: {
                super.handleEvent(reader, eventType);
                ++this.depth;
                if (this.depth >= this.values.length) {
                    this.growValues();
                }
                this.valueOffsets[this.depth] = 0;
                Arrays.fill(this.values[this.depth], '\u0000');
                int l = this.currentPath.length();
                int i = 0;
                while (i < reader.getAttributeCount()) {
                    QName attQName = this.getEventAttQName(reader, i);
                    this.currentPath.append(" @").append(this.encodeQName(attQName)).append(' ');
                    XPathValueMapper.hashString(reader.getAttributeValue(i).toCharArray(), this.attValue);
                    this.currentPath.append(this.attValue);
                    this.addValue();
                    this.currentPath.setLength(l);
                    ++i;
                }
                break;
            }
            case 2: {
                int l = this.currentPath.length();
                this.currentPath.append(' ').append(this.values[this.depth]);
                this.addValue();
                --this.depth;
                this.currentPath.setLength(l);
                super.handleEvent(reader, eventType);
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                this.hashText(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                super.handleEvent(reader, eventType);
                break;
            }
            case 9: {
                this.hashText(reader.getText());
            }
            default: {
                super.handleEvent(reader, eventType);
            }
        }
    }

    private void addValue() {
        char[] value = new char[this.currentPath.length()];
        this.currentPath.getChars(0, this.currentPath.length(), value, 0);
        this.pathValues.add(value);
    }

    public static char[] hashString(char[] value, char[] buf) {
        Arrays.fill(buf, '\u0000');
        int i = 0;
        while (i < value.length && i < 8) {
            buf[i % 8] = value[i];
            ++i;
        }
        i = 8;
        while (i < value.length) {
            buf[i % 8] = (char)(buf[i % 8] * 15 + value[i]);
            ++i;
        }
        return buf;
    }

    private void hashText(char[] textCharacters, int textStart, int textLength) {
        int j = 0;
        while (j <= this.depth) {
            int k = this.valueOffsets[j];
            int i = textStart;
            while (i < textLength + textStart) {
                this.values[j][k] = (char)(this.values[j][k] * 15 + textCharacters[i]);
                k = k == 7 ? 0 : ++k;
                ++i;
            }
            this.valueOffsets[j] = k;
            ++j;
        }
    }

    private void hashText(String text) {
        this.hashText(text.toCharArray(), 0, text.length());
    }

    private void growValues() {
        this.values = (char[][])Arrays.copyOf(this.values, this.values.length + 16);
        int i = 0;
        while (i < 16) {
            this.values[i + this.values.length] = new char[8];
            ++i;
        }
        this.valueOffsets = Arrays.copyOf(this.valueOffsets, this.valueOffsets.length + 16);
    }
}

