/*
 * Decompiled with CFR 0.152.
 */
package lux.index.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import lux.index.analysis.QNameTokenFilter;
import lux.index.analysis.TextOffsetTokenStream;
import lux.index.attribute.QNameAttribute;
import lux.xml.Offsets;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

public final class AttributeTokenStream
extends TextOffsetTokenStream {
    private final QNameAttribute qnameAtt = (QNameAttribute)this.addAttribute(QNameAttribute.class);
    private final QNameTokenFilter qnameTokenFilter = new QNameTokenFilter(this.getWrappedTokenStream());

    public AttributeTokenStream(String fieldName, Analyzer analyzer, TokenStream wrapped, XdmNode doc, Offsets offsets) {
        super(fieldName, analyzer, wrapped, doc, offsets);
        this.setWrappedTokenStream((TokenStream)this.qnameTokenFilter);
        this.contentIter = new ContentIterator(doc);
    }

    @Override
    public void reset(Reader reader) throws IOException {
        super.reset(reader);
        this.qnameTokenFilter.reset(this.getWrappedTokenStream());
        this.setWrappedTokenStream((TokenStream)this.qnameTokenFilter);
    }

    @Override
    protected void updateNodeAtts() {
        this.getAttributeQName();
    }

    private void getAttributeQName() {
        this.qnameAtt.clearQNames();
        QName qname = this.curNode.getNodeName();
        this.qnameAtt.addQName(new lux.xml.QName(qname.getNamespaceURI(), qname.getLocalName(), qname.getPrefix()));
    }

    private static class ContentIterator
    implements Iterator<XdmNode> {
        private XdmSequenceIterator descendants;
        private XdmSequenceIterator attributes;
        private XdmNode next = null;

        protected ContentIterator(XdmNode node) {
            this.descendants = node.axisIterator(Axis.DESCENDANT_OR_SELF);
            this.attributes = EMPTY;
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.getNext();
            return this.next != null;
        }

        private XdmNode getNext() {
            while (true) {
                if (this.attributes.hasNext()) {
                    this.next = (XdmNode)this.attributes.next();
                    return this.next;
                }
                if (!this.descendants.hasNext()) break;
                XdmNode node = (XdmNode)this.descendants.next();
                this.attributes = node.axisIterator(Axis.ATTRIBUTE);
            }
            return null;
        }

        @Override
        public XdmNode next() {
            if (this.hasNext()) {
                XdmNode node = this.next;
                this.next = null;
                return node;
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

