/*
 * Decompiled with CFR 0.152.
 */
package lux.index.field;

import java.util.Collections;
import lux.index.XPathValueMapper;
import lux.index.XmlIndexer;
import lux.index.analysis.PathValueTokenStream;
import lux.index.field.FieldDefinition;
import lux.index.field.FieldValues;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.Version;

public class PathValueField
extends FieldDefinition {
    private static final PathValueField instance = new PathValueField();

    public static PathValueField getInstance() {
        return instance;
    }

    protected PathValueField() {
        super("lux_path_value", (Analyzer)new WhitespaceAnalyzer(Version.LUCENE_41), Field.Store.NO, FieldDefinition.Type.TOKENS);
    }

    public Iterable<IndexableField> getFieldValues(XmlIndexer indexer) {
        XPathValueMapper mapper = (XPathValueMapper)indexer.getPathMapper();
        return new FieldValues(indexer.getConfiguration(), this, Collections.singleton(new TextField(indexer.getConfiguration().getFieldName(this), (TokenStream)new PathValueTokenStream(mapper.getPathValues()))));
    }
}

