/*
 * Decompiled with CFR 0.152.
 */
package lux.query;

import lux.index.IndexConfiguration;
import lux.query.BooleanPQuery;
import lux.query.ParseableQuery;
import lux.xml.QName;
import lux.xpath.AbstractExpression;
import lux.xpath.Sequence;
import lux.xquery.AttributeConstructor;
import lux.xquery.ElementConstructor;
import org.apache.lucene.search.BooleanClause;

public class SpanBooleanPQuery
extends BooleanPQuery {
    private static final QName SPAN_OR_QNAME = new QName("SpanOr");

    public SpanBooleanPQuery(BooleanClause.Occur occur, ParseableQuery ... queries) {
        super(occur, queries);
    }

    public SpanBooleanPQuery(BooleanPQuery.Clause ... clauses) {
        super(clauses);
    }

    @Override
    public ElementConstructor toXmlNode(String field, IndexConfiguration config) {
        if (this.getOccur().equals((Object)BooleanClause.Occur.MUST) || config.isOption(2048)) {
            return super.toXmlNode(field, config);
        }
        BooleanPQuery.Clause[] clauses = this.getClauses();
        AbstractExpression[] clauseExprs = new AbstractExpression[clauses.length];
        int i = 0;
        while (i < clauses.length) {
            clauseExprs[i] = clauses[i].getQuery().toXmlNode(field, config);
            ++i;
        }
        return new ElementConstructor(SPAN_OR_QNAME, new Sequence(clauseExprs), new AttributeConstructor[0]);
    }

    @Override
    public String toQueryString(String field, IndexConfiguration config) {
        if (this.getOccur().equals((Object)BooleanClause.Occur.MUST) || config.isOption(2048)) {
            return super.toQueryString(field, config);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("(lux_within:0");
        BooleanPQuery.Clause[] clauseArray = this.getClauses();
        int n = clauseArray.length;
        int n2 = 0;
        while (n2 < n) {
            BooleanPQuery.Clause clause = clauseArray[n2];
            buf.append(' ').append(clause.getQuery().toQueryString(field, config));
            ++n2;
        }
        buf.append(')');
        return buf.toString();
    }
}

