/*
 * Decompiled with CFR 0.152.
 */
package lux.query.parser;

import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.query.parser.NodeExtensions;
import lux.query.parser.NodeParser;
import lux.query.parser.NodeQueryBuilder;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.ext.ExtendableQueryParser;
import org.apache.lucene.queryparser.ext.Extensions;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.Version;

public class LuxQueryParser
extends ExtendableQueryParser {
    private final NodeQueryBuilder queryBuilder;

    public LuxQueryParser(Version matchVersion, String f, Analyzer a, Extensions ext, NodeQueryBuilder queryBuilder) {
        super(matchVersion, f, a, ext);
        this.queryBuilder = queryBuilder;
    }

    public static LuxQueryParser makeLuxQueryParser(IndexConfiguration config) {
        Analyzer elementTextAnalyzer = config.getField(FieldName.ELEMENT_TEXT).getAnalyzer();
        NodeQueryBuilder queryBuilder = new NodeQueryBuilder(elementTextAnalyzer, config.isOption(4));
        NodeParser nodeParser = new NodeParser(config.getFieldName(FieldName.XML_TEXT), config.getFieldName(FieldName.ELEMENT_TEXT), config.getFieldName(FieldName.ATTRIBUTE_TEXT), queryBuilder);
        NodeExtensions ext = new NodeExtensions(nodeParser);
        LuxQueryParser parser = new LuxQueryParser(IndexConfiguration.LUCENE_VERSION, config.getFieldName(FieldName.XML_TEXT), (Analyzer)config.getFieldAnalyzers(), ext, queryBuilder);
        return parser;
    }

    public void bindNamespacePrefix(String prefix, String namespaceURI) {
        this.queryBuilder.bindNamespacePrefix(prefix, namespaceURI);
    }

    public void clearNamespaces() {
        this.queryBuilder.clearNamespaces();
    }

    public Query parse(String queryString) throws ParseException {
        Query q = super.parse(queryString);
        return this.maybeConvert(q);
    }

    private Query maybeConvert(Query q) {
        Term term;
        if (!(q instanceof BooleanQuery)) {
            return q;
        }
        BooleanQuery bq = (BooleanQuery)q;
        if (bq.getClauses().length == 0) {
            return bq;
        }
        Query q1 = bq.getClauses()[0].getQuery();
        if (q1 instanceof TermQuery && ((term = ((TermQuery)q1).getTerm()).field().equals("lux_within") || term.field().equals("lux_near"))) {
            return this.toSpanQuery((Query)bq);
        }
        this.convertNestedSpans(bq);
        return bq;
    }

    private void convertNestedSpans(BooleanQuery bq) {
        for (BooleanClause clause : bq.clauses()) {
            Query q = clause.getQuery();
            Query converted = this.maybeConvert(q);
            if (converted == q) continue;
            clause.setQuery(converted);
        }
    }

    private SpanQuery toSpanQuery(Query q) {
        if (q instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)q;
            BooleanClause[] booleanClauses = bq.getClauses();
            if (booleanClauses.length == 0) {
                return new SpanOrQuery(new SpanQuery[0]);
            }
            Query q1 = booleanClauses[0].getQuery();
            if (q1 instanceof TermQuery) {
                int start;
                int slop;
                boolean inOrder;
                Term term = ((TermQuery)q1).getTerm();
                if (term.field().equals("lux_within")) {
                    inOrder = true;
                    slop = Integer.valueOf(term.text());
                    start = 1;
                } else if (term.field().equals("lux_near")) {
                    inOrder = false;
                    slop = Integer.valueOf(term.text());
                    start = 1;
                } else {
                    inOrder = true;
                    slop = 0;
                    start = 0;
                }
                SpanQuery[] clauses = this.convertClauses(booleanClauses, start);
                if (clauses.length == 1) {
                    return clauses[0];
                }
                if (booleanClauses[0].isRequired()) {
                    return new SpanNearQuery(clauses, slop, inOrder);
                }
                return new SpanOrQuery(clauses);
            }
        }
        if (q instanceof TermQuery) {
            return new SpanTermQuery(((TermQuery)q).getTerm());
        }
        throw new IllegalStateException("Can't convert query <" + q + "> of type " + q.getClass().getName() + " to a SpanQuery");
    }

    private SpanQuery[] convertClauses(BooleanClause[] clauses, int start) {
        SpanQuery[] spans = new SpanQuery[clauses.length - start];
        int i = start;
        while (i < clauses.length) {
            Query subquery = clauses[i].getQuery();
            spans[i - start] = this.toSpanQuery(subquery);
            ++i;
        }
        return spans;
    }

    public static final String escapeQParser(String s) {
        if (s.indexOf(32) >= 0) {
            return String.valueOf('\"') + s.replaceAll("\"", "\\\"") + '\"';
        }
        return ExtendableQueryParser.escape((String)s);
    }
}

