/*
 * Decompiled with CFR 0.152.
 */
package lux.query.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import lux.index.analysis.WildcardAnalyzer;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeQueryBuilder
implements QueryBuilder {
    private final Map<String, String> nsMap;
    private final Analyzer analyzer;
    private final Analyzer wildcardAnalyzer;
    private final boolean namespaceAware;

    public NodeQueryBuilder(Analyzer analyzer, boolean namespaceAware) {
        this.analyzer = analyzer;
        this.wildcardAnalyzer = new WildcardAnalyzer();
        this.nsMap = new HashMap<String, String>();
        this.namespaceAware = namespaceAware;
    }

    public Query getQuery(Element e) throws ParserException {
        String fieldName = DOMUtils.getAttributeWithInheritanceOrFail((Element)e, (String)"fieldName");
        String qName = DOMUtils.getAttributeWithInheritance((Element)e, (String)"qName");
        String text = DOMUtils.getText((Node)e);
        float boost = DOMUtils.getAttribute((Element)e, (String)"boost", (float)1.0f);
        return this.parseQueryTerm(fieldName, qName, text, boost);
    }

    void bindNamespacePrefix(String prefix, String namespaceURI) {
        if (StringUtils.isEmpty((String)namespaceURI)) {
            this.nsMap.remove(prefix);
        } else {
            this.nsMap.put(prefix, namespaceURI);
        }
    }

    void clearNamespaces() {
        this.nsMap.clear();
    }

    Query parseQueryTerm(String fieldName, String qName, String text, float boost) throws ParserException {
        Object q;
        Analyzer termAnalyzer;
        StringBuilder termText = new StringBuilder();
        boolean isWild = false;
        if (StringUtils.isNotEmpty((String)qName)) {
            if (qName.matches("[^{:]+:.*")) {
                String[] parts = qName.split(":", 2);
                String prefix = parts[0];
                String name = parts[1];
                if ("*".equals(prefix)) {
                    termText.append(name).append("*:");
                    isWild = true;
                } else {
                    String namespaceURI = this.nsMap.get(prefix);
                    if (namespaceURI == null) {
                        if (this.namespaceAware) {
                            throw new ParserException("unbound namespace prefix '" + prefix + "'");
                        }
                        termText.append(qName).append(':');
                    } else {
                        termText.append(name).append('{').append(namespaceURI).append("}:");
                    }
                }
            } else {
                termText.append(qName).append(':');
            }
        }
        int prefixLength = termText.length();
        if (text.indexOf(42) >= 0 || text.indexOf(63) >= 0) {
            if (text.matches(".*\\s.*")) {
                termAnalyzer = this.analyzer;
            } else {
                isWild = true;
                termAnalyzer = this.wildcardAnalyzer;
            }
        } else {
            termAnalyzer = this.analyzer;
        }
        PhraseQuery pq = new PhraseQuery();
        Term term = null;
        try {
            TokenStream ts = termAnalyzer.tokenStream(fieldName, (Reader)new StringReader(text));
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            if (ts.incrementToken()) {
                termText.append(termAtt.buffer(), 0, termAtt.length());
                term = new Term(fieldName, termText.toString());
                pq.add(term);
                while (ts.incrementToken()) {
                    termText.setLength(prefixLength);
                    termText.append(termAtt.buffer(), 0, termAtt.length());
                    term = new Term(fieldName, termText.toString());
                    pq.add(term);
                }
            }
            ts.end();
            ts.close();
        }
        catch (IOException ts) {
            // empty catch block
        }
        if (pq.getTerms().length > 1) {
            if (isWild) {
                throw new ParserException("wildcarded namespace prefix cannot be combined with a multi-word phrase");
            }
            q = pq;
        } else {
            if (term == null) {
                return new MatchAllDocsQuery();
            }
            q = isWild ? new WildcardQuery(term) : new TermQuery(term);
        }
        q.setBoost(boost);
        return q;
    }
}

