/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.xml.stream.XMLStreamException;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.XmlIndexer;
import lux.index.field.FieldDefinition;
import lux.solr.SolrIndexConfig;
import lux.xml.tinybin.TinyBinary;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.LoggerFactory;

public class LuxUpdateProcessor
extends UpdateRequestProcessor {
    private final SolrIndexConfig solrIndexConfig;
    private final IndexConfiguration indexConfig;
    private final Configuration saxonConfig;

    public LuxUpdateProcessor(SolrIndexConfig config, UpdateRequestProcessor next) {
        super(next);
        this.solrIndexConfig = config;
        this.indexConfig = this.solrIndexConfig.getIndexConfig();
        this.saxonConfig = this.solrIndexConfig.getCompiler().getProcessor().getUnderlyingConfiguration();
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        block9: {
            SolrInputDocument solrInputDocument = cmd.getSolrInputDocument();
            Object o = solrInputDocument.getFieldValue(this.indexConfig.getFieldName(FieldName.XML_STORE));
            XmlIndexer xmlIndexer = this.solrIndexConfig.checkoutXmlIndexer();
            try {
                if (o == null) break block9;
                String uri = (String)solrInputDocument.getFieldValue(this.indexConfig.getFieldName(FieldName.URI));
                try {
                    if (o instanceof String) {
                        String xml = (String)o;
                        xmlIndexer.index(new StringReader(xml), uri);
                    } else if (o instanceof byte[]) {
                        TinyBinary xml = new TinyBinary((byte[])o, Charset.forName("utf-8"));
                        xmlIndexer.index((NodeInfo)xml.getTinyDocument(this.saxonConfig), uri);
                    }
                }
                catch (XMLStreamException e) {
                    LoggerFactory.getLogger(LuxUpdateProcessor.class).error("Failed to parse " + (Object)((Object)FieldName.XML_STORE), (Throwable)e);
                }
                LuxUpdateProcessor.addDocumentFields(xmlIndexer, solrInputDocument);
            }
            finally {
                this.solrIndexConfig.returnXmlIndexer(xmlIndexer);
            }
        }
        if (this.next != null) {
            this.next.processAdd(cmd);
        }
    }

    public static void addDocumentFields(XmlIndexer indexer, SolrInputDocument doc) {
        IndexConfiguration indexConfig = indexer.getConfiguration();
        if (indexConfig.isOption(16)) {
            doc.removeField(indexConfig.getFieldName(FieldName.XML_STORE));
        }
        for (FieldDefinition field : indexConfig.getFields()) {
            String fieldName = indexConfig.getFieldName(field);
            if ((field == indexConfig.getField(FieldName.URI) || field == indexConfig.getField(FieldName.XML_STORE)) && doc.getField(fieldName) != null) continue;
            Iterable<?> values = field.getValues(indexer);
            if (values != null) {
                for (Object object : values) {
                    doc.addField(fieldName, object);
                }
                continue;
            }
            for (IndexableField indexableField : field.getFieldValues(indexer)) {
                doc.addField(fieldName, (Object)indexableField);
            }
        }
    }

    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        if (this.next != null) {
            this.next.processDelete(cmd);
        }
    }
}

