/*
 * Decompiled with CFR 0.152.
 */
package lux.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import lux.index.XmlIndexer;
import net.sf.saxon.s9api.SaxonApiException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;

public class LoadDemoData {
    public static void main(String[] argv) throws XMLStreamException, IOException, SaxonApiException {
        String indexDir = argv.length != 1 ? "solr/data/index" : argv[0];
        SimpleFSDirectory index = new SimpleFSDirectory(new File(indexDir));
        String dataDir = "samples/wikipedia";
        XmlIndexer indexer = new XmlIndexer();
        IndexWriter indexWriter = indexer.newIndexWriter((Directory)index);
        indexWriter.deleteAll();
        LoadDemoData.index(indexer, indexWriter, dataDir);
        indexWriter.commit();
        indexWriter.close(true);
    }

    private static void index(XmlIndexer indexer, IndexWriter indexWriter, String path) throws IOException, XMLStreamException {
        File file = new File(path);
        if (file.isFile()) {
            if (path.matches(".*\\.xml$")) {
                System.out.println(path);
                indexer.indexDocument(indexWriter, path, new FileInputStream(file));
            } else {
                System.out.println("skipping " + path);
            }
        } else {
            String[] stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                LoadDemoData.index(indexer, indexWriter, String.valueOf(path) + '/' + child);
                ++n2;
            }
        }
    }
}

