/*
 * Decompiled with CFR 0.152.
 */
package lux.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lux.xml.Offsets;
import lux.xml.SaxonDocBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;

public class OffsetDocBuilder
extends SaxonDocBuilder {
    private final Offsets offsets = new Offsets();
    private int lastTextLocation;
    private boolean fixupCRLF = false;

    public OffsetDocBuilder(Processor processor) throws SaxonApiException {
        super(processor);
    }

    @Override
    public void reset() {
        super.reset();
        this.offsets.reset();
    }

    @Override
    public void handleEvent(XMLStreamReader reader, int eventType) throws XMLStreamException {
        super.handleEvent(reader, eventType);
        switch (eventType) {
            case 7: {
                this.lastTextLocation = -1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                this.recordOffsets(reader);
                break;
            }
            case 12: {
                this.recordOffsets(reader, reader.getLocation().getCharacterOffset() + "<!CDATA[[".length(), reader.getTextLength());
                this.recordOffsets(reader, this.lastTextLocation, "]]>".length());
                break;
            }
            case 4: 
            case 6: {
                int textLength = reader.getTextLength();
                if (this.isFixupCRLF()) {
                    if (reader.getTextCharacters()[reader.getTextStart()] == '\n') {
                        this.recordOffsets(reader, reader.getLocation().getCharacterOffset() + 1, textLength);
                    } else {
                        this.recordOffsets(reader, reader.getLocation().getCharacterOffset(), textLength);
                    }
                    this.offsetCRLF(reader.getLocation().getCharacterOffset(), reader.getTextCharacters(), reader.getTextStart(), textLength);
                    break;
                }
                this.recordOffsets(reader, reader.getLocation().getCharacterOffset(), textLength);
                break;
            }
            case 9: {
                String text = reader.getText();
                this.recordOffsets(reader, reader.getLocation().getCharacterOffset(), text.length());
            }
        }
    }

    private void offsetCRLF(int location, char[] cbuf, int off, int size) {
        int i = off + 1;
        while (i < off + size) {
            if (cbuf[i] == '\n') {
                this.offsets.addDelta(location + off - i, (short)1);
            }
            ++i;
        }
    }

    private void recordOffsets(XMLStreamReader reader, int location, int textLength) throws XMLStreamException {
        if (this.lastTextLocation < 0) {
            this.offsets.addOffset(location);
        } else {
            this.offsets.addDelta(location, (short)(location - this.lastTextLocation));
        }
        this.lastTextLocation = location + textLength;
    }

    private void recordOffsets(XMLStreamReader reader) throws XMLStreamException {
        int location = reader.getLocation().getCharacterOffset();
        if (this.lastTextLocation >= 0 && location > this.lastTextLocation) {
            this.offsets.addDelta(location, (short)(location - this.lastTextLocation));
        }
        this.lastTextLocation = -1;
    }

    @Override
    public Offsets getOffsets() {
        return this.offsets;
    }

    public boolean isFixupCRLF() {
        return this.fixupCRLF;
    }

    public void setFixupCRLF(boolean fixupCRLF) {
        this.fixupCRLF = fixupCRLF;
    }
}

