/*
 * Decompiled with CFR 0.152.
 */
package lux.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lux.exception.LuxException;
import lux.xml.Offsets;
import lux.xml.StAXHandler;
import net.sf.saxon.s9api.BuildingStreamWriterImpl;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class SaxonDocBuilder
implements StAXHandler {
    private final DocumentBuilder builder;
    protected BuildingStreamWriterImpl writer;

    public SaxonDocBuilder(Processor processor) {
        this.builder = processor.newDocumentBuilder();
        try {
            this.writer = this.builder.newBuildingStreamWriter();
        }
        catch (SaxonApiException e) {
            throw new LuxException(e);
        }
    }

    public XdmNode getDocument() throws SaxonApiException {
        return this.writer.getDocumentNode();
    }

    @Override
    public void handleEvent(XMLStreamReader reader, int eventType) throws XMLStreamException {
        switch (eventType) {
            case 7: {
                this.writer.writeStartDocument(reader.getEncoding(), reader.getVersion());
                break;
            }
            case 8: {
                this.writer.writeEndDocument();
                break;
            }
            case 1: {
                String nsuri = reader.getNamespaceURI();
                if (nsuri == null) {
                    this.writer.writeStartElement(reader.getLocalName());
                } else {
                    String prefix = reader.getPrefix();
                    if (prefix == null) {
                        this.writer.writeStartElement(nsuri, reader.getLocalName());
                    } else {
                        this.writer.writeStartElement(prefix, reader.getLocalName(), nsuri);
                    }
                }
                int i = 0;
                while (i < reader.getNamespaceCount()) {
                    this.writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                    ++i;
                }
                i = 0;
                while (i < reader.getAttributeCount()) {
                    nsuri = reader.getAttributeNamespace(i);
                    if (nsuri == null) {
                        this.writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    } else {
                        String prefix = reader.getAttributePrefix(i);
                        if (prefix == null) {
                            this.writer.writeAttribute(nsuri, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                        } else {
                            this.writer.writeAttribute(prefix, nsuri, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                        }
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                this.writer.writeEndElement();
                break;
            }
            case 5: {
                this.writer.writeComment(reader.getText());
                break;
            }
            case 3: {
                if (reader.getPIData() == null) {
                    this.writer.writeProcessingInstruction(reader.getPITarget());
                    break;
                }
                this.writer.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
                break;
            }
            case 11: {
                this.writer.writeDTD(reader.getText());
                break;
            }
            case 12: {
                this.writer.writeCharacters(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                break;
            }
            case 4: 
            case 6: {
                int textLength = reader.getTextLength();
                this.writer.writeCharacters(reader.getTextCharacters(), reader.getTextStart(), textLength);
                break;
            }
            case 9: {
                String text = reader.getText();
                this.writer.writeCharacters(text);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized XMLStream event type: " + reader.getEventType());
            }
        }
    }

    @Override
    public void reset() {
        try {
            this.writer = this.builder.newBuildingStreamWriter();
        }
        catch (SaxonApiException e) {
            throw new LuxException(e);
        }
    }

    public Offsets getOffsets() {
        return null;
    }
}

