/*
 * Decompiled with CFR 0.152.
 */
package lux.xml;

public enum ValueType {
    VALUE("item", false, false),
    DOCUMENT("document-node"),
    NODE("node"),
    ELEMENT("element"),
    ATTRIBUTE("attribute"),
    TEXT("text"),
    COMMENT("comment"),
    PROCESSING_INSTRUCTION("processing-instruction"),
    ATOMIC("xs:anyAtomicType", true),
    STRING("xs:string", true),
    INT("xs:int", true),
    INTEGER("xs:integer", true),
    BOOLEAN("xs:boolean", true),
    BOOLEAN_FALSE("xs:boolean", true),
    DATE("xs:date", true),
    DATE_TIME("xs:dateTime", true),
    DAY("xs:gDay", true),
    MONTH_DAY("xs:gMonthDay", true),
    YEAR("xs:gYear", true),
    YEAR_MONTH("xs:gYearMonth", true),
    FLOAT("xs:float", true),
    DOUBLE("xs:double", true),
    DECIMAL("xs:decimal", true),
    TIME("xs:time", true),
    HEX_BINARY("xs:hexBinary", true),
    BASE64_BINARY("xs:base64Binary", true),
    MONTH("xs:gMonth", true),
    UNTYPED_ATOMIC("xs:untypedAtomic", true),
    QNAME("xs:QName", true),
    EMPTY("empty-sequence", false, false);

    public static final int EXACTLY_ZERO = 0;
    public static final int EXACTLY_ONE = 1;
    public static final int ZERO_OR_ONE = 2;
    public static final int ONE_OR_MORE = 3;
    public static final int ANY_NUMBER = 4;
    public static final String[] CARDINALITY_MARKER;
    public final boolean isNode;
    public final boolean isAtomic;
    public final String name;

    static {
        CARDINALITY_MARKER = new String[]{"", "", "?", "+", "*"};
    }

    private ValueType(String nodeTest) {
        this.isNode = true;
        this.isAtomic = false;
        this.name = nodeTest;
    }

    private ValueType(String typeName, boolean isAtomic) {
        this.isAtomic = isAtomic;
        this.isNode = false;
        this.name = typeName;
    }

    private ValueType(String typeName, boolean isAtomic, boolean isNode) {
        this.isAtomic = isAtomic;
        this.isNode = isNode;
        this.name = typeName;
    }

    public boolean is(ValueType other) {
        if (this == other) {
            return true;
        }
        if (other == VALUE) {
            return true;
        }
        if (this.isAtomic) {
            return other == ATOMIC;
        }
        if (this.isNode) {
            return other == NODE;
        }
        return false;
    }

    public ValueType restrict(ValueType type) {
        if (this.is(type)) {
            return this;
        }
        if (type.is(this)) {
            return type;
        }
        if (type.isNode && this.isNode) {
            return NODE;
        }
        if (type.isAtomic && this.isAtomic) {
            return ATOMIC;
        }
        return VALUE;
    }

    public ValueType promote(ValueType type) {
        if (this == type) {
            return this;
        }
        if (this.isNode && type.isNode) {
            return NODE;
        }
        if (this.isAtomic && type.isAtomic) {
            return ATOMIC;
        }
        return VALUE;
    }

    public String toString() {
        if (!this.isAtomic) {
            return String.valueOf(this.name) + "()";
        }
        return this.name;
    }
}

