/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import lux.xpath.ExpressionVisitor;
import lux.xpath.Visitable;
import lux.xquery.VariableContext;

public abstract class AbstractExpression
implements Visitable {
    protected AbstractExpression sup;
    protected AbstractExpression[] subs;
    private final Type type;

    protected AbstractExpression(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void acceptSubs(ExpressionVisitor visitor) {
        int i = 0;
        while (i < this.subs.length && !visitor.isDone()) {
            int j = visitor.isReverse() ? this.subs.length - i - 1 : i;
            AbstractExpression sub = this.subs[j].accept(visitor);
            if (sub != this.subs[j]) {
                this.subs[j] = sub;
            }
            ++i;
        }
    }

    public AbstractExpression getSuper() {
        return this.sup;
    }

    public AbstractExpression[] getSubs() {
        return this.subs;
    }

    protected void setSubs(AbstractExpression ... subExprs) {
        AbstractExpression[] abstractExpressionArray = this.subs = subExprs;
        int n = this.subs.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractExpression sub = abstractExpressionArray[n2];
            sub.sup = this;
            ++n2;
        }
    }

    public abstract void toString(StringBuilder var1);

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    public AbstractExpression getRoot() {
        return null;
    }

    public boolean isAbsolute() {
        return this.getRoot() != null;
    }

    public boolean isDocumentOrdered() {
        if (this.subs != null) {
            AbstractExpression[] abstractExpressionArray = this.subs;
            int n = this.subs.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractExpression sub = abstractExpressionArray[n2];
                if (!sub.isDocumentOrdered()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public AbstractExpression replaceRoot(AbstractExpression replacement) {
        if (this.subs != null) {
            int i = 0;
            while (i < this.subs.length) {
                AbstractExpression replaced = this.subs[i].replaceRoot(replacement);
                if (replaced != this.subs[i]) {
                    this.subs[i] = replaced;
                }
                ++i;
            }
        }
        return this;
    }

    protected void appendSub(StringBuilder buf, AbstractExpression sub) {
        if (sub.getPrecedence() <= this.getPrecedence()) {
            buf.append('(');
            sub.toString(buf);
            buf.append(')');
        } else {
            sub.toString(buf);
        }
    }

    public AbstractExpression getTail() {
        return null;
    }

    public AbstractExpression getLastContextStep() {
        return this;
    }

    public VariableContext getBindingContext() {
        return null;
    }

    public abstract int getPrecedence();

    public static enum Type {
        PATH_EXPRESSION,
        PATH_STEP,
        PREDICATE,
        BINARY_OPERATION,
        SET_OPERATION,
        LITERAL,
        ROOT,
        DOT,
        FUNCTION_CALL,
        SEQUENCE,
        UNARY_MINUS,
        SUBSEQUENCE,
        LET,
        VARIABLE,
        COMPUTED_ELEMENT,
        ELEMENT,
        ATTRIBUTE,
        TEXT,
        FLWOR,
        CONDITIONAL,
        COMMENT,
        DOCUMENT_CONSTRUCTOR,
        PROCESSING_INSTRUCTION,
        SATISFIES,
        INSTANCE_OF,
        CASTABLE,
        TREAT;

    }
}

