/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import lux.xml.QName;
import lux.xml.ValueType;

public class NodeTest {
    private final ValueType type;
    private final QName name;

    public NodeTest(ValueType type, QName name) {
        if (type.isAtomic) {
            throw new IllegalArgumentException("Attempt to construct a NodeTest with type " + (Object)((Object)type) + " which is not a type of node");
        }
        this.type = type;
        this.name = name;
    }

    public NodeTest(ValueType type) {
        this(type, null);
    }

    public ValueType getType() {
        return this.type;
    }

    public QName getQName() {
        return this.name;
    }

    public boolean isWild() {
        return this.name == null || this.name.getLocalPart().equals("*");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    public void toString(StringBuilder buf) {
        if (this.name == null) {
            buf.append(this.type.name).append("()");
            return;
        }
        switch (this.type) {
            case NODE: 
            case TEXT: 
            case COMMENT: {
                buf.append(this.type.name).append("()");
                break;
            }
            case ELEMENT: 
            case ATTRIBUTE: {
                if ("*".equals(this.name.getLocalPart())) {
                    if (this.name.getPrefix().isEmpty()) {
                        buf.append(this.type.name).append("()");
                        break;
                    }
                    buf.append(this.name.getPrefix()).append(":*");
                    break;
                }
                if ("*".equals(this.name.getPrefix())) {
                    this.name.toString(buf);
                    break;
                }
                buf.append(this.type.name).append("(");
                this.name.toString(buf);
                buf.append(')');
                break;
            }
            case DOCUMENT: {
                buf.append(this.type.name).append("(element(");
                this.name.toString(buf);
                buf.append("))");
                break;
            }
            case PROCESSING_INSTRUCTION: {
                buf.append(this.type.name).append('(').append(this.name.getLocalPart()).append(')');
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid node type " + (Object)((Object)this.type));
            }
        }
    }
}

