/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import lux.xpath.AbstractExpression;
import lux.xpath.Dot;
import lux.xpath.ExpressionVisitor;
import lux.xpath.NodeTest;

public class PathStep
extends AbstractExpression {
    private final Axis axis;
    private final NodeTest nodeTest;

    public PathStep(Axis axis, NodeTest nodeTest) {
        super(AbstractExpression.Type.PATH_STEP);
        this.axis = axis;
        this.nodeTest = nodeTest;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public NodeTest getNodeTest() {
        return this.nodeTest;
    }

    @Override
    public void toString(StringBuilder buf) {
        buf.append((Object)this.axis).append("::");
        this.nodeTest.toString(buf);
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public int getPrecedence() {
        return 100;
    }

    @Override
    public boolean isDocumentOrdered() {
        return this.axis.isForward;
    }

    @Override
    public AbstractExpression getLastContextStep() {
        if (this.axis == Axis.Self && this.nodeTest.isWild()) {
            return Dot.getInstance();
        }
        return this;
    }

    public static enum Axis {
        Self("self", true),
        Child("child", true),
        Parent("parent", false),
        Descendant("descendant", true),
        DescendantSelf("descendant-or-self", false),
        Ancestor("ancestor", false),
        AncestorSelf("ancestor-or-self", false),
        Preceding("preceding", false),
        Following("following", true),
        PrecedingSibling("preceding-sibling", false),
        FollowingSibling("following-sibling", true),
        Attribute("attribute", true);

        public final String name;
        public final boolean isForward;

        private Axis(String name, boolean forward) {
            this.name = name;
            this.isForward = forward;
        }

        public String toString() {
            return this.name;
        }
    }
}

