/*
 * Decompiled with CFR 0.152.
 */
package lux.xqts;

import java.io.File;
import lux.QueryContext;
import lux.QueryStats;
import lux.XdmResultSet;
import lux.compiler.SaxonTranslator;
import lux.xqts.ErrorIgnorer;
import lux.xqts.RunnerBase;
import lux.xqts.TestCase;
import lux.xqts.TestGroup;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.value.AnyURIValue;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BenchmarkRunner
extends RunnerBase {
    @BeforeClass
    public static void setup() throws Exception {
        BenchmarkRunner.setup(72, "TestSourcesTiny");
    }

    private boolean runTest(String caseName) throws Exception {
        TestCase test1 = catalog.getTestCaseByName(caseName);
        Assert.assertNotNull((String)caseName, (Object)test1);
        return this.runComparison(test1);
    }

    private void runSaxonBenchmark(TestCase test1) throws Exception {
        ++numtests;
        QueryContext context = new QueryContext();
        this.bindExternalVariables(test1, context);
        saxonConfig.setCollectionURIResolver((CollectionURIResolver)new BenchmarkURIResolver());
        saxonConfig.setDefaultCollection(String.valueOf(catalog.getDirectory()) + "/TestSourcesTiny");
        XQueryExecutable xq = eval.getCompiler().getXQueryCompiler().compile(test1.getBenchmarkQueryText());
        xq.load().evaluate();
    }

    private void runLuxBenchmark(TestCase test1) throws Exception {
        ++numtests;
        QueryContext context = new QueryContext();
        this.bindExternalVariables(test1, context);
        saxonConfig.setDefaultCollection("lux:/");
        XQueryExecutable expr = eval.getCompiler().compile(test1.getBenchmarkQueryText());
        context.setContextItem(test1.getContextItem());
        QueryStats stats = new QueryStats();
        eval.setQueryStats(stats);
        eval.evaluate(expr, context);
    }

    private boolean runComparison(TestCase test1) throws Exception {
        ++numtests;
        if (this.printDetailedDiagnostics) {
            ErrorIgnorer ignorer = (ErrorIgnorer)saxonConfig.getErrorListener();
            ignorer.setShowErrors(true);
        }
        QueryContext context = new QueryContext();
        this.bindExternalVariables(test1, context);
        saxonConfig.setDefaultCollection(String.valueOf(catalog.getDirectory()) + "/TestSourcesTiny");
        saxonConfig.setCollectionURIResolver((CollectionURIResolver)new BenchmarkURIResolver());
        boolean threwException = false;
        XQueryExecutable xq = null;
        XdmValue value = null;
        try {
            xq = eval.getCompiler().getXQueryCompiler().compile(test1.getBenchmarkQueryText());
            value = xq.load().evaluate();
        }
        catch (Exception e) {
            threwException = true;
        }
        saxonConfig.setDefaultCollection("lux:/");
        XQueryExecutable expr = eval.getCompiler().compile(test1.getBenchmarkQueryText());
        context.setContextItem(test1.getContextItem());
        QueryStats stats = new QueryStats();
        eval.setQueryStats(stats);
        XdmResultSet results = eval.evaluate(expr, context);
        if (!results.getErrors().isEmpty()) {
            if (!threwException) {
                ++numfailed;
                System.err.println("test failed with unexpected exception: " + results.getErrors().get(0));
            }
            return true;
        }
        Boolean comparedEqual = test1.compareResult(results, value);
        if (comparedEqual == null || comparedEqual.booleanValue()) {
            return true;
        }
        ++numfailed;
        System.err.println(String.valueOf(test1.getName()) + " failed");
        if (this.printDetailedDiagnostics) {
            System.err.println("base impl returned: " + value.toString());
            System.err.println("lux impl returned: " + results.iterator().next().toString());
            System.err.println(new SaxonTranslator(saxonConfig).queryFor(xq));
        }
        return false;
    }

    private void runTestGroup(String groupName) throws Exception {
        TestGroup group = catalog.getTestGroupByName(groupName);
        Assert.assertNotNull((String)groupName, (Object)group);
        this.testOneGroup(group);
    }

    private void benchmarkLuxGroup(TestGroup group) throws Exception {
        for (TestCase test : group.getTestCases()) {
            if (test.isExpectError() || test.getComparisonMode() == TestCase.ComparisonMode.Ignore || "emptydoc".equals(test.getPrincipalData())) continue;
            try {
                this.runLuxBenchmark(test);
            }
            catch (Exception e) {
                ++numfailed;
                System.err.println("lux benchmark test " + test.getName() + " failed with exception: " + e.getMessage());
            }
        }
        for (TestGroup subgroup : group.getSubGroups()) {
            this.benchmarkLuxGroup(subgroup);
        }
    }

    private void benchmarkSaxonGroup(TestGroup group) throws Exception {
        for (TestCase test : group.getTestCases()) {
            if (test.isExpectError() || test.getComparisonMode() == TestCase.ComparisonMode.Ignore || "emptydoc".equals(test.getPrincipalData())) continue;
            try {
                this.runSaxonBenchmark(test);
            }
            catch (Exception e) {
                ++numfailed;
                System.err.println("base benchmark test " + test.getName() + " failed with exception: " + e.getMessage());
            }
        }
        for (TestGroup subgroup : group.getSubGroups()) {
            this.benchmarkSaxonGroup(subgroup);
        }
    }

    private void testOneGroup(TestGroup group) throws Exception {
        for (TestCase test : group.getTestCases()) {
            if (test.isExpectError() || test.getComparisonMode() == TestCase.ComparisonMode.Ignore || "emptydoc".equals(test.getPrincipalData())) continue;
            boolean ok = true;
            try {
                ok = this.runComparison(test);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertTrue((String)(String.valueOf(test.getName()) + " fails"), (boolean)ok);
        }
        for (TestGroup subgroup : group.getSubGroups()) {
            this.testOneGroup(subgroup);
        }
    }

    @Test
    public void testOneBenchmark() throws Exception {
        this.printDetailedDiagnostics = true;
        Assert.assertTrue((boolean)this.runTest("Parenexpr-15"));
    }

    @Test
    public void testGroup() throws Exception {
        this.runTestGroup("MinimalConformance");
    }

    @Test
    public void testBenchmarkGroup() throws Exception {
        this.terminateOnException = false;
        long t0 = System.currentTimeMillis();
        this.benchmarkSaxonGroup(catalog.getTestGroupByName("MinimalConformance"));
        long t1 = System.currentTimeMillis();
        this.benchmarkLuxGroup(catalog.getTestGroupByName("MinimalConformance"));
        long t2 = System.currentTimeMillis();
        int optDocsRead = eval.getDocReader().getCacheMisses();
        System.out.println("Base runtime (all documents): " + (t1 - t0) + "; read " + collectionSize * numtests + " docs");
        System.out.println("Optimized runtime (documents filtered by query): " + (t2 - t1) + "; read " + optDocsRead + " docs");
    }

    static class BenchmarkURIResolver
    implements CollectionURIResolver {
        BenchmarkURIResolver() {
        }

        public SequenceIterator<?> resolve(String href, String base, XPathContext context) throws XPathException {
            File dir = new File(href);
            String[] listing = dir.list();
            Item[] uris = new Item[listing.length];
            int i = 0;
            while (i < listing.length) {
                uris[i] = new AnyURIValue((CharSequence)(String.valueOf(href) + '/' + listing[i]));
                ++i;
            }
            return new ArrayIterator(uris);
        }
    }
}

