/*
 * Decompiled with CFR 0.152.
 */
package lux.xqts;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import lux.xqts.TestCase;
import lux.xqts.TestGroup;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;

class Catalog {
    private Processor processor;
    private XdmNode catalogDocument;
    private XPathCompiler compiler;
    private String directory;
    private ArrayList<TestGroup> testGroups = new ArrayList();
    private DocumentBuilder builder;
    private Serializer serializer;
    private HashMap<String, String> sourceFiles;
    private HashMap<String, TestCase> cases = new HashMap();
    static final QName TEST_SUITE = new QName("http://www.w3.org/2005/02/query-test-XQTSCatalog", "test-suite");
    static final QName SOURCES = new QName("http://www.w3.org/2005/02/query-test-XQTSCatalog", "sources");
    static final QName SOURCE = new QName("http://www.w3.org/2005/02/query-test-XQTSCatalog", "source");
    static final QName ID = new QName("ID");
    static final QName FILE_NAME = new QName("FileName");

    public Catalog(String filepath, Processor processor) throws SaxonApiException, IOException {
        this.directory = filepath;
        this.processor = processor;
        this.compiler = processor.newXPathCompiler();
        this.compiler.declareNamespace("xqts", "http://www.w3.org/2005/02/query-test-XQTSCatalog");
        System.out.println("reading XQTS Catalog...");
        this.builder = processor.newDocumentBuilder();
        this.serializer = processor.newSerializer();
        this.serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        this.serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
        this.catalogDocument = this.builder.build(new File(String.valueOf(filepath) + "/XQTSCatalog.xml"));
        this.buildSourceFiles(filepath);
        this.buildTestGroups();
        System.out.println("read " + this.cases.size() + " test cases");
    }

    private void buildSourceFiles(String filePath) throws IOException, SaxonApiException {
        XdmSequenceIterator testSuite = this.catalogDocument.axisIterator(Axis.CHILD, TEST_SUITE);
        XdmNode testSuiteNode = (XdmNode)testSuite.next();
        XdmSequenceIterator sources = testSuiteNode.axisIterator(Axis.CHILD, SOURCES);
        XdmNode sourcesNode = (XdmNode)sources.next();
        XdmSequenceIterator children = sourcesNode.axisIterator(Axis.CHILD, SOURCE);
        this.sourceFiles = new HashMap();
        while (children.hasNext()) {
            XdmNode sourceNode = (XdmNode)children.next();
            this.sourceFiles.put(sourceNode.getAttributeValue(ID), String.valueOf(filePath) + '/' + sourceNode.getAttributeValue(FILE_NAME));
        }
    }

    private void buildTestGroups() throws IOException, SaxonApiException {
        XdmSequenceIterator testSuite = this.catalogDocument.axisIterator(Axis.CHILD, TEST_SUITE);
        XdmNode testSuiteNode = (XdmNode)testSuite.next();
        XdmSequenceIterator children = testSuiteNode.axisIterator(Axis.CHILD, TestGroup.TEST_GROUP);
        while (children.hasNext()) {
            XdmNode testGroupNode = (XdmNode)children.next();
            TestGroup testGroup = new TestGroup(testGroupNode, this);
            this.testGroups.add(testGroup);
        }
    }

    public TestCase getTestCaseByName(String name) {
        return this.cases.get(name);
    }

    public TestGroup getTestGroupByName(String name) {
        for (TestGroup testGroup : this.getTopTestGroups()) {
            TestGroup group = testGroup.getTestGroupByName(name);
            if (group == null) continue;
            return group;
        }
        return null;
    }

    public Iterable<TestGroup> getTopTestGroups() {
        return this.testGroups;
    }

    public String getSourceFileByID(String id) {
        return this.sourceFiles.get(id);
    }

    public String getDirectory() {
        return this.directory;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public DocumentBuilder getBuilder() {
        return this.builder;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void putTestCase(String name, TestCase testCase) {
        this.cases.put(name, testCase);
    }
}

