/*
 * Decompiled with CFR 0.152.
 */
package lux.xqts;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.ErrorListener;
import lux.Compiler;
import lux.Evaluator;
import lux.QueryContext;
import lux.index.IndexConfiguration;
import lux.index.XmlIndexer;
import lux.search.LuxSearcher;
import lux.xml.QName;
import lux.xqts.Catalog;
import lux.xqts.ErrorIgnorer;
import lux.xqts.TestCase;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.AfterClass;

public class RunnerBase {
    protected static Catalog catalog;
    private static RAMDirectory dir;
    private static LuxSearcher searcher;
    protected static Evaluator eval;
    protected static Configuration saxonConfig;
    protected static Processor processor;
    protected static int collectionSize;
    protected static int numtests;
    protected static int numfailed;
    private static int numignored;
    protected boolean terminateOnException = true;
    protected boolean printDetailedDiagnostics = false;
    protected boolean benchmark = false;
    protected boolean benchmarkSaxon = false;

    protected static void setup(int indexOptions, String sourceDirectory) throws Exception {
        dir = new RAMDirectory();
        IndexConfiguration indexConfig = IndexConfiguration.makeIndexConfiguration(indexOptions);
        XmlIndexer indexer = new XmlIndexer(indexConfig);
        Compiler compiler = new Compiler(indexConfig);
        processor = compiler.getProcessor();
        saxonConfig = processor.getUnderlyingConfiguration();
        saxonConfig.getParseOptions().setEntityResolver(null);
        saxonConfig.setErrorListener((ErrorListener)new ErrorIgnorer());
        saxonConfig.setConfigurationProperty("http://saxon.sf.net/feature/xqueryPreserveNamespaces", (Object)true);
        saxonConfig.setConfigurationProperty("http://saxon.sf.net/feature/xqueryInheritNamespaces", (Object)true);
        catalog = new Catalog("/users/sokolov/workspace/XQTS_1_0_3", processor);
        RunnerBase.indexDirectory(indexer, catalog, sourceDirectory);
        numtests = 0;
        numignored = 0;
        numfailed = 0;
        searcher = new LuxSearcher((Directory)dir);
        eval = new Evaluator(compiler, searcher, null);
    }

    private static void indexDirectory(XmlIndexer indexer, Catalog catalog2, String sourceDirectory) throws IOException {
        File[] listing;
        IndexWriter indexWriter = indexer.newIndexWriter((Directory)dir);
        File catalogSourceDir = new File(String.valueOf(catalog.getDirectory()) + '/' + sourceDirectory);
        int count = 0;
        System.out.println("indexing test sources...");
        File[] fileArray = listing = catalogSourceDir.listFiles();
        int n = listing.length;
        int n2 = 0;
        while (n2 < n) {
            File source = fileArray[n2];
            if (source.getName().endsWith(".xml")) {
                try {
                    indexer.indexDocument(indexWriter, source.getPath(), new FileInputStream(source));
                }
                catch (XMLStreamException e) {
                    System.err.println("Failed to index " + source.getPath() + ": " + e.getMessage());
                }
                ++count;
            }
            ++n2;
        }
        collectionSize = count;
        System.out.println("indexed " + count + " documents");
        indexWriter.commit();
        indexWriter.close();
    }

    @AfterClass
    public static void cleanup() throws Exception {
        System.out.println("Ran " + numtests + " tests");
        System.out.println(String.valueOf(numfailed) + " tests failed; " + numignored + " ignored");
    }

    protected void bindExternalVariables(TestCase test1, QueryContext context) throws IOException, FileNotFoundException, SaxonApiException {
        if (test1.getExternalVariables() != null) {
            for (Map.Entry<String, TestCase.VariableBinding> binding : test1.getExternalVariables().entrySet()) {
                Object item;
                String filename = binding.getValue().value;
                if (binding.getValue().type == TestCase.VariableBinding.Type.FILE) {
                    if (filename.endsWith(".xq")) {
                        String text = IOUtils.toString((InputStream)new FileInputStream(filename));
                        XdmValue result = eval.evaluate(text).getXdmValue();
                        item = result.iterator().next();
                    } else {
                        item = filename.endsWith(".xml") ? eval.build(new InputStreamReader(new FileInputStream(filename)), filename) : new XdmAtomicValue(IOUtils.toString((InputStream)new FileInputStream(filename)));
                    }
                } else {
                    item = new XdmAtomicValue(filename);
                }
                context.bindVariable(new QName(binding.getKey()), item);
            }
        }
    }
}

