/*
 * Decompiled with CFR 0.152.
 */
package lux.xqts;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import lux.XdmResultSet;
import lux.xqts.Catalog;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import org.apache.commons.io.IOUtils;

public class TestCase {
    private final Catalog catalog;
    private final String name;
    private final String path;
    private final String scenario;
    private final String queryName;
    private final boolean xpath2;
    private final XdmValue contextItem;
    private final ComparisonMode comparisonMode;
    private HashMap<String, VariableBinding> externalVariables;
    private final String queryText;
    private String[] outputFileText;
    private final boolean expectError;
    private String principalData;
    static final String XQTS_NS = "http://www.w3.org/2005/02/query-test-XQTSCatalog";
    static final QName COMPARE = new QName("compare");
    static final QName IS_X_PATH2 = new QName("is-XPath2");
    static final QName SCENARIO = new QName("scenario");
    static final QName FILE_PATH = new QName("FilePath");
    static final QName NAME = new QName("name");
    static final QName VARIABLE = new QName("variable");
    static final QName ROLE = new QName("role");
    static final QName QUERY = new QName("http://www.w3.org/2005/02/query-test-XQTSCatalog", "query");
    static final QName INPUT_QUERY = new QName("http://www.w3.org/2005/02/query-test-XQTSCatalog", "input-query");
    static final QName INPUT_FILE = new QName("http://www.w3.org/2005/02/query-test-XQTSCatalog", "input-file");
    static final QName INPUT_URI = new QName("http://www.w3.org/2005/02/query-test-XQTSCatalog", "input-URI");
    static final QName OUTPUT_FILE = new QName("http://www.w3.org/2005/02/query-test-XQTSCatalog", "output-file");
    static final QName CONTEXT_ITEM = new QName("http://www.w3.org/2005/02/query-test-XQTSCatalog", "contextItem");
    private static final QName EXPECTED_ERROR = new QName("http://www.w3.org/2005/02/query-test-XQTSCatalog", "expected-error");

    public TestCase(XdmNode testCase, Catalog catalog) throws FileNotFoundException, IOException, SaxonApiException {
        String text;
        this.name = testCase.getAttributeValue(NAME);
        this.path = testCase.getAttributeValue(FILE_PATH);
        this.scenario = testCase.getAttributeValue(SCENARIO);
        this.xpath2 = Boolean.valueOf(testCase.getAttributeValue(IS_X_PATH2));
        this.externalVariables = new HashMap();
        this.catalog = catalog;
        XdmNode query = (XdmNode)testCase.axisIterator(Axis.CHILD, QUERY).next();
        this.queryName = query.getAttributeValue(NAME);
        XdmSequenceIterator context = testCase.axisIterator(Axis.CHILD, CONTEXT_ITEM);
        if (context.hasNext()) {
            String contextItemFileName = context.next().getStringValue();
            this.contextItem = catalog.getBuilder().build(new File(catalog.getSourceFileByID(contextItemFileName)));
        } else {
            this.contextItem = null;
        }
        this.comparisonMode = this.readOutputText(testCase);
        File queryFile = new File(this.getQueryPath(this.queryName));
        this.queryText = text = IOUtils.toString((InputStream)new FileInputStream(queryFile));
        this.bindExternalVariables(testCase, INPUT_FILE, VariableBinding.Type.FILE);
        this.bindExternalVariables(testCase, INPUT_URI, VariableBinding.Type.URI);
        XdmSequenceIterator inputQuery = testCase.axisIterator(Axis.CHILD, INPUT_QUERY);
        while (inputQuery.hasNext()) {
            XdmNode q = (XdmNode)inputQuery.next();
            String filename = q.getAttributeValue(NAME);
            VariableBinding binding = new VariableBinding();
            binding.type = VariableBinding.Type.FILE;
            binding.value = this.getQueryPath(filename);
            this.externalVariables.put(q.getAttributeValue(VARIABLE), binding);
        }
        XdmSequenceIterator errors = testCase.axisIterator(Axis.CHILD, EXPECTED_ERROR);
        this.expectError = errors.hasNext();
        catalog.putTestCase(this.name, this);
    }

    private void bindExternalVariables(XdmNode testCase, QName elementName, VariableBinding.Type type) {
        XdmSequenceIterator input = testCase.axisIterator(Axis.CHILD, elementName);
        XdmNode inputFileNode = null;
        while (input.hasNext()) {
            inputFileNode = (XdmNode)input.next();
            String inputVariable = inputFileNode.getAttributeValue(VARIABLE);
            String role = inputFileNode.getAttributeValue(ROLE);
            String inputFileName = inputFileNode.axisIterator(Axis.CHILD).next().getStringValue();
            VariableBinding binding = new VariableBinding();
            binding.type = type;
            binding.role = role;
            binding.value = this.catalog.getSourceFileByID(inputFileName);
            this.externalVariables.put(inputVariable, binding);
            if (!"principal-data".equals(role)) continue;
            this.principalData = inputFileName;
        }
    }

    private String getQueryPath(String filename) {
        return String.valueOf(this.catalog.getDirectory()) + "/Queries/XQuery/" + this.path + '/' + filename + ".xq";
    }

    private ComparisonMode readOutputText(XdmNode testCase) throws IOException, FileNotFoundException {
        XdmSequenceIterator output = testCase.axisIterator(Axis.CHILD, OUTPUT_FILE);
        if (!output.hasNext()) {
            return ComparisonMode.Ignore;
        }
        XdmNode outputFileNode = (XdmNode)output.next();
        int outputFileCount = 1;
        ComparisonMode mode = ComparisonMode.valueOf(outputFileNode.getAttributeValue(COMPARE));
        while (output.hasNext()) {
            ++outputFileCount;
            output.next();
        }
        this.outputFileText = new String[outputFileCount];
        outputFileCount = 0;
        output = testCase.axisIterator(Axis.CHILD, OUTPUT_FILE);
        while (output.hasNext()) {
            outputFileNode = (XdmNode)output.next();
            XdmSequenceIterator outputFileSeq = outputFileNode.axisIterator(Axis.CHILD);
            if (outputFileSeq.hasNext()) {
                String outputFileName = outputFileSeq.next().getStringValue();
                File outputFile = new File(String.valueOf(this.catalog.getDirectory()) + "/ExpectedTestResults/" + this.path + '/' + outputFileName);
                String text = IOUtils.toString((InputStream)new FileInputStream(outputFile));
                this.outputFileText[outputFileCount++] = text;
                continue;
            }
            this.outputFileText = null;
        }
        return mode;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getScenario() {
        return this.scenario;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public String getBenchmarkQueryText() {
        String benchQueryText = this.queryText;
        for (Map.Entry<String, VariableBinding> entry : this.externalVariables.entrySet()) {
            VariableBinding binding = entry.getValue();
            String varName = entry.getKey();
            if (!"principal-data".equals(binding.role)) continue;
            benchQueryText = benchQueryText.replace("declare variable $" + varName + " external;", "declare variable $" + varName + " := collection();");
        }
        return benchQueryText;
    }

    public boolean isXpath2() {
        return this.xpath2;
    }

    public ComparisonMode getComparisonMode() {
        return this.comparisonMode;
    }

    public String[] getOutputText() {
        return this.outputFileText;
    }

    public Boolean compareResult(Iterable<?> results) throws SaxonApiException, XPathException {
        switch (this.getComparisonMode()) {
            case Text: 
            case Fragment: {
                String result;
                String string = result = results == null ? "" : TestCase.resultToString(results);
                if ("-0".equals(result)) {
                    result = "0";
                }
                boolean isNode = !result.isEmpty() && results.iterator().next() instanceof XdmNode;
                String[] stringArray = this.getOutputText();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XdmNode resultDoc;
                    String output = stringArray[n2];
                    if ("-0".equals(output)) {
                        output = "0";
                    }
                    XdmNode docWrapped = this.createWrappedNode(output);
                    if (isNode ? this.areNodesEqual(docWrapped, resultDoc = this.createWrappedNode(result)) : this.normalizeWhitespace(result).equals(this.normalizeWhitespace(this.unescape(output)))) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            case XML: {
                String[] stringArray = this.getOutputText();
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String output = stringArray[n3];
                    XdmNode doc = this.catalog.getBuilder().build((Source)new StreamSource(new ByteArrayInputStream(output.getBytes())));
                    for (Object node : results) {
                        if (!this.areNodesEqual(doc, (XdmNode)node)) continue;
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
        }
        return null;
    }

    private Object normalizeWhitespace(String s) {
        return s.replaceAll("\\s+", " ").trim();
    }

    private XdmNode createWrappedNode(Object node) throws SaxonApiException {
        String s = node.toString();
        s = s.replaceFirst("<\\?xml[^>]+>", "");
        return this.catalog.getBuilder().build((Source)new StreamSource(new ByteArrayInputStream(("<a>" + s + "</a>").getBytes())));
    }

    public static String resultToString(Iterable<?> results) throws XPathException {
        Iterator<?> iterator = results.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        Object result = iterator.next();
        StringBuilder buf = new StringBuilder(TestCase.resultToString(result));
        boolean lastNode = result instanceof XdmNode;
        while (iterator.hasNext()) {
            result = iterator.next();
            if (!(result instanceof XdmNode) && !lastNode) {
                buf.append(' ');
            }
            buf.append(TestCase.resultToString(result));
            lastNode = result instanceof XdmNode;
        }
        return buf.toString();
    }

    public static String resultToString(Object o) throws XPathException {
        if (o instanceof XdmNode) {
            return TestCase.resultToString((XdmNode)o);
        }
        return o.toString();
    }

    public static String resultToString(XdmNode node) throws XPathException {
        StringWriter sw = new StringWriter();
        Properties props = new Properties();
        props.setProperty("method", "xml");
        props.setProperty("indent", "no");
        props.setProperty("omit-xml-declaration", "yes");
        QueryResult.serialize((NodeInfo)node.getUnderlyingNode(), (Result)new StreamResult(sw), (Properties)props);
        return sw.toString();
    }

    private boolean areNodesEqual(XdmNode node1, XdmNode node2) throws XPathException {
        if (node2.getNodeKind() != XdmNodeKind.DOCUMENT && node1.getNodeKind() == XdmNodeKind.DOCUMENT) {
            node1 = (XdmNode)node1.axisIterator(Axis.CHILD).next();
        }
        return DeepEqual.deepEquals((SequenceIterator)SingletonIterator.makeIterator((Item)node1.getUnderlyingNode()), (SequenceIterator)SingletonIterator.makeIterator((Item)node2.getUnderlyingNode()), (GenericAtomicComparer)new GenericAtomicComparer((StringCollator)CodepointCollator.getInstance(), this.catalog.getProcessor().getUnderlyingConfiguration().getConversionContext()), (Configuration)this.catalog.getProcessor().getUnderlyingConfiguration(), (int)62);
    }

    private String unescape(String s) {
        return s.replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">").replace("\r\n", "\n");
    }

    public String getPrincipalData() {
        return this.principalData;
    }

    public XdmValue getContextItem() {
        return this.contextItem;
    }

    public String toString() {
        return "XQueryTestCase{" + this.name + "}";
    }

    public boolean isExpectError() {
        return this.expectError;
    }

    public HashMap<String, VariableBinding> getExternalVariables() {
        return this.externalVariables;
    }

    public Boolean compareResult(XdmResultSet results, XdmValue value) throws XPathException, SaxonApiException {
        XdmSequenceIterator iter = value.iterator();
        Iterator<XdmItem> iterator = results.iterator();
        while (iterator.hasNext()) {
            XdmNode node;
            XdmItem o;
            XdmItem result = o = iterator.next();
            XdmItem item = iter.next();
            if (item.isAtomicValue()) {
                if (item.getStringValue().equals(result.getStringValue())) continue;
                System.err.println(String.valueOf(item.getStringValue()) + " is not " + result.getStringValue());
                return false;
            }
            XdmNode expected = this.nodeFor(item);
            if (this.areNodesEqual(expected, node = this.nodeFor(result))) continue;
            return false;
        }
        return true;
    }

    private XdmNode nodeFor(XdmItem item) throws SaxonApiException {
        XdmNode itemNode = item.isAtomicValue() ? this.createWrappedNode(item) : (XdmNode)item;
        return itemNode;
    }

    public static enum ComparisonMode {
        XML,
        Text,
        Fragment,
        Ignore,
        Inspect;

    }

    static class VariableBinding {
        String value;
        String role;
        Type type;

        VariableBinding() {
        }

        static enum Type {
            URI,
            FILE;

        }
    }
}

