/*
 * Decompiled with CFR 0.152.
 */
package lux.xqts;

import java.io.IOException;
import java.util.ArrayList;
import lux.xqts.Catalog;
import lux.xqts.TestCase;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class TestGroup {
    private final int depth;
    private final String name;
    private final ArrayList<TestGroup> subgroups = new ArrayList();
    private final ArrayList<TestCase> cases = new ArrayList();
    static final QName TEST_CASE = new QName("http://www.w3.org/2005/02/query-test-XQTSCatalog", "test-case");
    static final QName TEST_GROUP = new QName("http://www.w3.org/2005/02/query-test-XQTSCatalog", "test-group");

    public TestGroup(XdmNode testGroupNode, Catalog catalog) throws IOException, SaxonApiException {
        this(testGroupNode, catalog, 1);
    }

    private TestGroup(XdmNode testGroupNode, Catalog catalog, int depth) throws IOException, SaxonApiException {
        this.name = testGroupNode.getAttributeValue(TestCase.NAME);
        this.depth = depth;
        XdmSequenceIterator children = testGroupNode.axisIterator(Axis.CHILD);
        while (children.hasNext()) {
            XdmNode child = (XdmNode)children.next();
            if (child.getNodeName() == null) continue;
            if (child.getNodeName().equals((Object)TEST_GROUP)) {
                TestGroup subgroup = new TestGroup(child, catalog, depth + 1);
                this.subgroups.add(subgroup);
                continue;
            }
            if (!child.getNodeName().equals((Object)TEST_CASE)) continue;
            TestCase test = new TestCase(child, catalog);
            this.cases.add(test);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getDepth() {
        return this.depth;
    }

    public TestGroup getTestGroupByName(String groupName) {
        if (this.name.equals(groupName)) {
            return this;
        }
        for (TestGroup testGroup : this.subgroups) {
            TestGroup group = testGroup.getTestGroupByName(groupName);
            if (group == null) continue;
            return group;
        }
        return null;
    }

    public Iterable<TestCase> getTestCases() {
        return this.cases;
    }

    public Iterable<TestGroup> getSubGroups() {
        return this.subgroups;
    }

    public String getBannerString() {
        StringBuilder buf = new StringBuilder();
        this.appendStars(buf);
        buf.append(' ');
        buf.append(this.getName());
        return buf.toString();
    }

    private void appendStars(StringBuilder buf) {
        int i = 1;
        while (i < 5) {
            if (i >= this.depth) {
                buf.append('*');
            } else {
                buf.append(' ');
            }
            ++i;
        }
    }
}

