/*
 * Decompiled with CFR 0.152.
 */
package lux.xqts;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import lux.Compiler;
import lux.QueryContext;
import lux.QueryStats;
import lux.compiler.PathOptimizer;
import lux.compiler.SaxonTranslator;
import lux.exception.LuxException;
import lux.xqts.ErrorIgnorer;
import lux.xqts.RunnerBase;
import lux.xqts.TestCase;
import lux.xqts.TestGroup;
import lux.xquery.XQuery;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmValue;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRunner
extends RunnerBase {
    private static final int MIL = 1000000;
    private long compile0;
    private long compile1;
    private long compileTime;
    private long translateTime;
    private long optimizeTime;
    private long evalTime;
    private long bindTime;
    private String luxQuery;

    @BeforeClass
    public static void setup() throws Exception {
        TestRunner.setup(8, "TestSources");
    }

    private boolean runTest(String caseName) throws Exception {
        TestCase test1 = catalog.getTestCaseByName(caseName);
        Assert.assertNotNull((String)("test case not found in catalog: " + caseName), (Object)test1);
        return this.runTest(test1);
    }

    /*
     * Unable to fully structure code
     */
    private boolean runTest(TestCase test1) throws Exception {
        block16: {
            block17: {
                block18: {
                    block15: {
                        block14: {
                            ++TestRunner.numtests;
                            context = new QueryContext();
                            t00 = System.nanoTime();
                            this.bindExternalVariables(test1, context);
                            t0 = System.nanoTime();
                            expr = this.compileXQuery(test1.getQueryText());
                            context.setContextItem(test1.getContextItem());
                            if (this.printDetailedDiagnostics) {
                                TestRunner.eval.setQueryStats(new QueryStats());
                            }
                            t1 = System.nanoTime();
                            results = TestRunner.eval.evaluate(expr, context);
                            t2 = System.nanoTime();
                            this.bindTime += t0 - t00;
                            this.evalTime += t2 - t1;
                            if (!this.benchmark) break block14;
                            return true;
                        }
                        if (!results.getErrors().isEmpty()) {
                            throw results.getErrors().get(0);
                        }
                        comparedEqual = test1.compareResult(results);
                        if (comparedEqual != null && !comparedEqual.booleanValue()) break block15;
                        return true;
                    }
                    try {
                        System.err.println(String.valueOf(test1.getName()) + " Mismatch: " + TestCase.resultToString(results) + " is not " + test1.getOutputText()[0]);
                        ++TestRunner.numfailed;
                        if (this.printDetailedDiagnostics) {
                            currentStrategy = TestRunner.eval.getCompiler().getSearchStrategy();
                            TestRunner.eval.getCompiler().setSearchStrategy(Compiler.SearchStrategy.NONE);
                            System.err.print(test1.getQueryText());
                            xq = TestRunner.eval.getCompiler().getXQueryCompiler().compile(test1.getQueryText());
                            results = TestRunner.eval.evaluate(xq, context);
                            item = results.getXdmValue().itemAt(0);
                            if (!test1.compareResult((Iterable<?>)item).booleanValue()) {
                                System.err.println(String.valueOf(test1.getName()) + " Saxon fails too?");
                            } else {
                                System.err.println(new SaxonTranslator(TestRunner.saxonConfig).queryFor(xq));
                            }
                            TestRunner.eval.getCompiler().setSearchStrategy(currentStrategy);
                        }
                        return false;
                    }
                    catch (Exception e) {
                        if (test1.isExpectError() || test1.getComparisonMode() == TestCase.ComparisonMode.Ignore) break block16;
                        ++TestRunner.numfailed;
                        error = e.getMessage();
                        if (error != null && error.length() > 1024) {
                            error = error.substring(0, 1024);
                        }
                        System.err.println(String.valueOf(test1.getName()) + " at " + test1.getPath() + " Unexpected Error: " + error);
                        if (!this.printDetailedDiagnostics) break block17;
                        xq = TestRunner.eval.getCompiler().getXQueryCompiler().compile(test1.getQueryText());
                        xqeval = xq.load();
                        if (context.getVariableBindings() == null) break block18;
                        ** for (binding : context.getVariableBindings().entrySet())
                    }
lbl-1000:
                    // 1 sources

                    {
                        saxonQName = new net.sf.saxon.s9api.QName((QName)binding.getKey());
                        xqeval.setExternalVariable(saxonQName, (XdmValue)binding.getValue());
                        continue;
                    }
                }
                System.err.print("translated query: " + this.luxQuery + "\n\n");
                try {
                    item = xqeval.evaluateSingle();
                    System.err.println(String.valueOf(test1.getQueryText()) + " returns " + item);
                }
                catch (Exception e1) {
                    System.err.println(String.valueOf(test1.getQueryText()) + "\n\n failed while trying to print diagnostics");
                    e1.printStackTrace();
                }
            }
            if (this.terminateOnException) {
                throw e;
            }
            return false;
        }
        return true;
    }

    private XQueryExecutable compileXQuery(String exprString) throws LuxException {
        XQueryExecutable xquery;
        long t0 = System.nanoTime();
        try {
            xquery = eval.getCompiler().getXQueryCompiler().compile((Reader)new StringReader(exprString));
        }
        catch (SaxonApiException e) {
            throw new LuxException(e);
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
        long t1 = System.nanoTime();
        this.compile0 += t1 - t0;
        this.compileTime += t1 - t0;
        XQuery abstractQuery = eval.getCompiler().makeTranslator().queryFor(xquery);
        long t2 = System.nanoTime();
        this.translateTime += t2 - t1;
        if (eval.getCompiler().getSearchStrategy() != Compiler.SearchStrategy.NONE) {
            PathOptimizer optimizer = new PathOptimizer(eval.getCompiler().getIndexConfiguration());
            XQuery optimizedQuery = optimizer.optimize(abstractQuery);
            this.luxQuery = optimizedQuery.toString();
        } else {
            this.luxQuery = abstractQuery.toString();
        }
        long t3 = System.nanoTime();
        this.optimizeTime += t3 - t2;
        try {
            xquery = eval.getCompiler().getXQueryCompiler().compile((Reader)new StringReader(this.luxQuery));
        }
        catch (SaxonApiException e) {
            System.err.print("Error compiling " + this.luxQuery + "\n");
            throw new LuxException(e);
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
        float compileTimeRatio = (float)(t3 - t2) / (float)(t1 - t0);
        if (t3 - t2 > 2L * (t1 - t0)) {
            System.out.println("Query got " + compileTimeRatio + " times harder to compile after optimization");
        }
        long t4 = System.nanoTime();
        this.compileTime += t4 - t3;
        this.compile1 += t4 - t3;
        return xquery;
    }

    private void runTestGroup(String groupName) throws Exception {
        ErrorIgnorer ignorer = (ErrorIgnorer)saxonConfig.getErrorListener();
        if (this.printDetailedDiagnostics) {
            ignorer.setShowErrors(true);
        } else {
            ignorer.setShowErrors(false);
        }
        TestGroup group = catalog.getTestGroupByName(groupName);
        Assert.assertNotNull((String)groupName, (Object)group);
        this.testOneGroup(group);
    }

    private void testOneGroup(TestGroup group) throws Exception {
        for (TestCase test : group.getTestCases()) {
            this.runTest(test);
        }
        for (TestGroup subgroup : group.getSubGroups()) {
            this.testOneGroup(subgroup);
        }
    }

    @Test
    public void testOneTest() throws Exception {
        this.printDetailedDiagnostics = true;
        Assert.assertTrue((boolean)this.runTest("K2-sequenceExprTypeswitch-14"));
    }

    @Test
    public void testGroup() throws Exception {
        this.terminateOnException = false;
        this.runTestGroup("MinimalConformance");
    }

    @Test
    public void testBenchmarkCompiler() throws Exception {
        this.benchmarkComparison(5, "MinimalConformance");
    }

    private void benchmarkComparison(int runs, String testGroup) throws Exception {
        this.terminateOnException = false;
        this.benchmark = true;
        Compiler compiler = eval.getCompiler();
        compiler.setSearchStrategy(Compiler.SearchStrategy.LUX_SEARCH);
        this.runTestGroup(testGroup);
        compiler.setSearchStrategy(Compiler.SearchStrategy.NONE);
        this.runTestGroup(testGroup);
        System.out.println("Benchmark Saxon alone");
        this.benchmark(runs, testGroup);
        System.out.println("Benchmark including Lux optimize");
        compiler.setSearchStrategy(Compiler.SearchStrategy.LUX_SEARCH);
        this.benchmark(runs, testGroup);
    }

    private void benchmark(int runs, String testGroup) throws Exception {
        this.evalTime = 0L;
        this.compileTime = 0L;
        this.compile0 = 0L;
        this.compile1 = 0L;
        this.bindTime = 0L;
        this.optimizeTime = 0L;
        this.translateTime = 0L;
        long t0 = System.currentTimeMillis();
        int i = 0;
        while (i < runs) {
            this.runTestGroup(testGroup);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        System.out.println(String.format("total time=%dms, bind=%dms, compile=%dms, translate=%dms, optimize=%dms, eval=%dms\n", t1 - t0, this.bindTime / 1000000L, this.compileTime / 1000000L, this.translateTime / 1000000L, this.optimizeTime / 1000000L, this.evalTime / 1000000L));
        System.out.println(String.format("compile0=%d, compile1=%d\n", this.compile0 / 1000000L, this.compile1 / 1000000L));
    }

    @Test
    public void testBenchmark() throws Exception {
        this.terminateOnException = false;
        this.benchmark = true;
        eval.getCompiler().setSearchStrategy(Compiler.SearchStrategy.LUX_SEARCH);
        this.benchmarkComparison(50, "PathExpr");
    }
}

