/*
 * Decompiled with CFR 0.152.
 */
package lux.xquery;

import lux.xml.QName;
import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;
import lux.xpath.LiteralExpression;
import lux.xpath.Namespace;
import lux.xquery.AttributeConstructor;

public class ElementConstructor
extends AbstractExpression {
    private final QName name;
    private final Namespace[] namespaces;
    private final AttributeConstructor[] attributes;

    public QName getName() {
        return this.name;
    }

    public ElementConstructor(QName qname, Namespace[] namespaces, AbstractExpression content, AttributeConstructor ... attributes) {
        super(AbstractExpression.Type.ELEMENT);
        this.name = qname;
        this.subs = new AbstractExpression[]{content};
        this.namespaces = namespaces;
        this.attributes = attributes;
    }

    public ElementConstructor(QName qname, AbstractExpression content, AttributeConstructor ... attributes) {
        this(qname, null, content, attributes);
    }

    public ElementConstructor(QName qname, AttributeConstructor ... attributes) {
        super(AbstractExpression.Type.ELEMENT);
        this.name = qname;
        this.subs = new AbstractExpression[0];
        this.namespaces = null;
        this.attributes = attributes;
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        this.acceptSubs(visitor);
        return visitor.visit(this);
    }

    @Override
    public void toString(StringBuilder buf) {
        AbstractExpression content;
        int i;
        boolean hasNsDecl;
        buf.append('<');
        this.name.toString(buf);
        boolean bl = hasNsDecl = this.namespaces != null && this.namespaces.length > 0;
        if (hasNsDecl) {
            buf.append(' ');
            this.appendNamespace(this.namespaces[0], buf);
            i = 1;
            while (i < this.namespaces.length) {
                buf.append(' ');
                this.appendNamespace(this.namespaces[i], buf);
                ++i;
            }
        }
        if (this.attributes != null && this.attributes.length > 0) {
            if (this.attributes[0] != null) {
                buf.append(' ');
                this.appendAttribute(this.attributes[0], buf);
            }
            i = 1;
            while (i < this.attributes.length) {
                if (this.attributes[i] != null) {
                    buf.append(' ');
                    this.appendAttribute(this.attributes[i], buf);
                }
                ++i;
            }
        }
        if ((content = this.getContent()) == null) {
            buf.append(" />");
        } else {
            buf.append('>');
            switch (content.getType()) {
                case ELEMENT: {
                    content.toString(buf);
                    break;
                }
                case LITERAL: {
                    if (content == LiteralExpression.EMPTY) break;
                    LiteralExpression.escapeText(((LiteralExpression)content).getValue().toString(), buf);
                    break;
                }
                case SEQUENCE: {
                    AbstractExpression kid;
                    boolean allElements = true;
                    AbstractExpression[] abstractExpressionArray = content.getSubs();
                    int n = abstractExpressionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        kid = abstractExpressionArray[n2];
                        if (kid.getType() != AbstractExpression.Type.ELEMENT) {
                            allElements = false;
                            break;
                        }
                        ++n2;
                    }
                    if (allElements) {
                        abstractExpressionArray = content.getSubs();
                        n = abstractExpressionArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            kid = abstractExpressionArray[n2];
                            kid.toString(buf);
                            ++n2;
                        }
                        break;
                    }
                }
                default: {
                    buf.append('{');
                    content.toString(buf);
                    buf.append('}');
                }
            }
            buf.append("</");
            this.name.toString(buf);
            buf.append('>');
        }
    }

    private AbstractExpression getContent() {
        return this.subs.length > 0 ? this.subs[0] : null;
    }

    private void appendNamespace(Namespace ns, StringBuilder buf) {
        buf.append("xmlns");
        if (!ns.getPrefix().isEmpty()) {
            buf.append(':');
            buf.append(ns.getPrefix());
        }
        buf.append("=\"");
        buf.append(ns.getNamespace());
        buf.append('\"');
    }

    private void appendAttribute(AttributeConstructor attr, StringBuilder buf) {
        buf.append(((LiteralExpression)attr.getName()).getValue().toString());
        buf.append('=');
        LiteralExpression.quoteString(((LiteralExpression)attr.getContent()).getValue().toString(), buf);
    }

    @Override
    public int getPrecedence() {
        return 0;
    }
}

