/*
 * Decompiled with CFR 0.152.
 */
package lux.xquery;

import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;
import lux.xquery.FLWORClause;
import lux.xquery.WhereClause;

public class FLWOR
extends AbstractExpression {
    private final FLWORClause[] clauses;

    public FLWOR(AbstractExpression returnExpression, FLWORClause ... clauses) {
        super(AbstractExpression.Type.FLWOR);
        this.clauses = clauses;
        this.subs = new AbstractExpression[]{returnExpression};
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        int i = 0;
        while (i < this.clauses.length) {
            this.clauses[i].accept(visitor);
            ++i;
        }
        this.subs[0] = this.getReturnExpression().accept(visitor);
        return visitor.visit(this);
    }

    @Override
    public void toString(StringBuilder buf) {
        boolean inWhereClause = false;
        FLWORClause[] fLWORClauseArray = this.clauses;
        int n = this.clauses.length;
        int n2 = 0;
        while (n2 < n) {
            FLWORClause clause = fLWORClauseArray[n2];
            if (clause instanceof WhereClause) {
                if (inWhereClause) {
                    buf.append("and ");
                    clause.getSequence().toString(buf);
                } else {
                    inWhereClause = true;
                    clause.toString(buf);
                }
            } else {
                clause.toString(buf);
            }
            buf.append("\n ");
            ++n2;
        }
        buf.append("return ");
        this.getReturnExpression().toString(buf);
        buf.append("\n");
    }

    public AbstractExpression getReturnExpression() {
        return this.subs[0];
    }

    public FLWORClause[] getClauses() {
        return this.clauses;
    }

    @Override
    public AbstractExpression replaceRoot(AbstractExpression replacement) {
        super.replaceRoot(replacement);
        FLWORClause[] fLWORClauseArray = this.clauses;
        int n = this.clauses.length;
        int n2 = 0;
        while (n2 < n) {
            FLWORClause clause = fLWORClauseArray[n2];
            clause.getSequence().replaceRoot(replacement);
            ++n2;
        }
        return this;
    }

    @Override
    public AbstractExpression getRoot() {
        return this.getReturnExpression().getRoot();
    }

    @Override
    public int getPrecedence() {
        return 3;
    }

    @Override
    public AbstractExpression getLastContextStep() {
        return this.getReturnExpression().getLastContextStep();
    }
}

