/*
 * Decompiled with CFR 0.152.
 */
package lux.xquery;

import java.util.ArrayList;
import java.util.Collections;
import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;
import lux.xpath.LiteralExpression;
import lux.xquery.FLWORClause;
import lux.xquery.SortKey;

public class OrderByClause
extends FLWORClause {
    private final ArrayList<SortKey> sortKeys = new ArrayList();

    public OrderByClause(SortKey[] sortKeys) {
        Collections.addAll(this.sortKeys, sortKeys);
    }

    @Override
    public AbstractExpression getSequence() {
        return LiteralExpression.EMPTY;
    }

    @Override
    public void setSequence(AbstractExpression seq) {
    }

    public ArrayList<SortKey> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public void toString(StringBuilder buf) {
        if (this.sortKeys.isEmpty()) {
            return;
        }
        buf.append("order by ");
        this.sortKeys.get(0).toString(buf);
        int i = 1;
        while (i < this.sortKeys.size()) {
            buf.append(", ");
            this.sortKeys.get(i).toString(buf);
            ++i;
        }
    }

    @Override
    public OrderByClause accept(ExpressionVisitor visitor) {
        int i = 0;
        while (i < this.sortKeys.size()) {
            AbstractExpression key2;
            SortKey sk = this.sortKeys.get(i);
            AbstractExpression key = sk.getKey();
            if (key != (key2 = key.accept(visitor))) {
                this.sortKeys.set(i, new SortKey(key2, sk.getOrder(), sk.getCollation(), sk.isEmptyLeast()));
            }
            ++i;
        }
        return visitor.visit(this);
    }
}

