/*
 * Decompiled with CFR 0.152.
 */
package lux.xquery;

import lux.xpath.AbstractExpression;
import lux.xpath.LiteralExpression;
import lux.xpath.Namespace;
import lux.xquery.FunctionDefinition;
import lux.xquery.ModuleImport;
import lux.xquery.VariableDefinition;
import org.apache.commons.lang.StringUtils;

public class XQuery {
    private final FunctionDefinition[] functionDefinitions;
    private final Namespace[] namespaceDeclarations;
    private final String defaultElementNamespace;
    private final String defaultFunctionNamespace;
    private final String defaultCollation;
    private final VariableDefinition[] externalVariables;
    private final ModuleImport[] importedModules;
    private final AbstractExpression body;
    private final String baseURI;
    private final Boolean preserveNamespaces;
    private final Boolean inheritNamespaces;
    private final boolean emptyLeast;

    public XQuery(String defaultElementNamespace, String defaultFunctionNamespace, String defaultCollation, ModuleImport[] importedModules, Namespace[] namespaceDeclarations, VariableDefinition[] variableDefinitions, FunctionDefinition[] defs, AbstractExpression body, String baseURI, Boolean copyNamespacesPreserve, Boolean copyNamespacesInherit, boolean emptyLeast) {
        this.namespaceDeclarations = namespaceDeclarations;
        this.externalVariables = variableDefinitions;
        this.defaultCollation = defaultCollation;
        this.defaultElementNamespace = defaultElementNamespace;
        this.defaultFunctionNamespace = defaultFunctionNamespace;
        this.functionDefinitions = defs;
        this.body = body;
        this.baseURI = baseURI;
        this.inheritNamespaces = copyNamespacesInherit;
        this.preserveNamespaces = copyNamespacesPreserve;
        this.emptyLeast = emptyLeast;
        this.importedModules = importedModules;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    public void toString(StringBuilder buf) {
        Object def;
        int n;
        int n2;
        Object[] objectArray;
        if (this.inheritNamespaces != null || this.preserveNamespaces != null) {
            buf.append("declare copy-namespaces ");
            if (this.preserveNamespaces == null || !this.preserveNamespaces.booleanValue()) {
                buf.append("no-preserve, ");
            } else {
                buf.append("preserve, ");
            }
            if (this.inheritNamespaces == null || this.inheritNamespaces.booleanValue()) {
                buf.append("inherit");
            } else {
                buf.append("no-inherit");
            }
            buf.append(";\n");
        }
        if (this.baseURI != null) {
            buf.append("declare base-uri ");
            LiteralExpression.quoteString(this.baseURI, buf);
            buf.append(";\n");
        }
        if (StringUtils.isNotBlank((String)this.defaultCollation)) {
            buf.append("declare default collation ");
            LiteralExpression.quoteString(this.defaultCollation, buf);
            buf.append(";\n");
        }
        if (!this.emptyLeast) {
            buf.append("declare default order empty greatest;\n");
        }
        if (StringUtils.isNotBlank((String)this.defaultElementNamespace)) {
            buf.append("declare default element namespace ");
            LiteralExpression.quoteString(this.defaultElementNamespace, buf);
            buf.append(";\n");
        }
        if (StringUtils.isNotBlank((String)this.defaultFunctionNamespace) && !this.defaultFunctionNamespace.equals("http://www.w3.org/2005/xpath-functions")) {
            buf.append("declare default function namespace ");
            LiteralExpression.quoteString(this.defaultFunctionNamespace, buf);
            buf.append(";\n");
        }
        if (this.namespaceDeclarations != null) {
            objectArray = this.namespaceDeclarations;
            n2 = this.namespaceDeclarations.length;
            n = 0;
            while (n < n2) {
                block21: {
                    Object ns = objectArray[n];
                    if (!((Namespace)ns).getPrefix().isEmpty() && !"xml".equals(((Namespace)ns).getPrefix())) {
                        ModuleImport[] moduleImportArray = this.importedModules;
                        int n3 = this.importedModules.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ModuleImport importedModule = moduleImportArray[n4];
                            if (!importedModule.getPrefix().equals(((Namespace)ns).getPrefix())) {
                                ++n4;
                                continue;
                            }
                            break block21;
                        }
                        buf.append("declare namespace ").append(((Namespace)ns).getPrefix()).append('=');
                        LiteralExpression.quoteString(((Namespace)ns).getNamespace(), buf);
                        buf.append(";\n");
                    }
                }
                ++n;
            }
        }
        if (this.importedModules != null) {
            objectArray = this.importedModules;
            n2 = this.importedModules.length;
            n = 0;
            while (n < n2) {
                Object importedModule = objectArray[n];
                ((ModuleImport)importedModule).toString(buf);
                ++n;
            }
        }
        if (this.externalVariables != null) {
            objectArray = this.externalVariables;
            n2 = this.externalVariables.length;
            n = 0;
            while (n < n2) {
                def = objectArray[n];
                ((VariableDefinition)def).toString(buf);
                ++n;
            }
        }
        if (this.functionDefinitions != null) {
            objectArray = this.functionDefinitions;
            n2 = this.functionDefinitions.length;
            n = 0;
            while (n < n2) {
                def = objectArray[n];
                ((FunctionDefinition)def).toString(buf);
                ++n;
            }
        }
        this.body.toString(buf);
    }

    public AbstractExpression getBody() {
        return this.body;
    }

    public FunctionDefinition[] getFunctionDefinitions() {
        return this.functionDefinitions;
    }

    public Namespace[] getNamespaceDeclarations() {
        return this.namespaceDeclarations;
    }

    public VariableDefinition[] getVariableDefinitions() {
        return this.externalVariables;
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public Boolean isPreserveNamespaces() {
        return this.preserveNamespaces;
    }

    public Boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public boolean isEmptyLeast() {
        return this.emptyLeast;
    }

    public ModuleImport[] getModuleImports() {
        return this.importedModules;
    }
}

