/*
 * Decompiled with CFR 0.152.
 */
package lux;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import lux.DocIDNumberAllocator;
import lux.exception.LuxException;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.field.TinyBinaryField;
import lux.xml.tinybin.TinyBinary;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;

public class CachingDocReader {
    private final LRUCache<Integer, XdmNode> cache = new LRUCache(512);
    private final String xmlFieldName;
    private final String uriFieldName;
    private final HashSet<String> fieldsToRetrieve;
    private final DocumentBuilder builder;
    private final Configuration config;
    private int cacheHits = 0;
    private int cacheMisses = 0;
    private long buildTime = 0L;

    public CachingDocReader(DocumentBuilder builder, Configuration config, IndexConfiguration indexConfig) {
        this.builder = builder;
        this.config = config;
        this.xmlFieldName = indexConfig.getFieldName(FieldName.XML_STORE);
        this.uriFieldName = indexConfig.getFieldName(FieldName.URI);
        this.fieldsToRetrieve = new HashSet();
        this.fieldsToRetrieve.add(this.xmlFieldName);
        this.fieldsToRetrieve.add(this.uriFieldName);
    }

    public XdmNode get(int docID, IndexReader reader) throws IOException {
        XdmNode node = (XdmNode)this.cache.get(docID);
        if (node != null) {
            ++this.cacheHits;
            return node;
        }
        DocumentStoredFieldVisitor fieldSelector = new DocumentStoredFieldVisitor(this.fieldsToRetrieve);
        reader.document(docID, (StoredFieldVisitor)fieldSelector);
        Document document = fieldSelector.getDocument();
        String xml = document.get(this.xmlFieldName);
        String uri = "lux:/" + document.get(this.uriFieldName);
        DocIDNumberAllocator docIdAllocator = (DocIDNumberAllocator)this.config.getDocumentNumberAllocator();
        docIdAllocator.setNextDocID(docID);
        long t0 = System.nanoTime();
        byte[] bytes = null;
        if (xml == null) {
            BytesRef binaryValue = document.getBinaryValue(this.xmlFieldName);
            if (binaryValue == null) {
                Logger.getLogger(CachingDocReader.class).warn((Object)("Document " + docID + " has no content"));
                bytes = new byte[]{};
            } else {
                bytes = binaryValue.bytes;
            }
            if (bytes.length > 4 && bytes[0] == 84 && bytes[1] == 73 && bytes[2] == 78 && bytes[3] == 89) {
                TinyBinary tb = new TinyBinary(bytes, TinyBinaryField.UTF8);
                node = new XdmNode((NodeInfo)tb.getTinyDocument(this.config));
            } else {
                xml = "<binary xmlns=\"http://luxdb.net\" />";
            }
        }
        if (node == null) {
            StreamSource source = new StreamSource(new StringReader(xml));
            source.setSystemId(uri);
            try {
                node = this.builder.build((Source)source);
            }
            catch (SaxonApiException e) {
                throw new LuxException(e);
            }
            if (bytes != null) {
                ((TinyDocumentImpl)node.getUnderlyingNode()).setUserData("_binaryDocument", (Object)bytes);
            }
        }
        ((TinyDocumentImpl)node.getUnderlyingNode()).setSystemId(uri);
        this.buildTime += System.nanoTime() - t0;
        this.cache.put(docID, node);
        ++this.cacheMisses;
        return node;
    }

    public int getCacheHits() {
        return this.cacheHits;
    }

    public int getCacheMisses() {
        return this.cacheMisses;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public void clear() {
        this.cache.clear();
    }

    static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        protected int maxsize;

        public LRUCache(int maxsize) {
            super(maxsize * 4 / 3 + 1, 0.75f, true);
            this.maxsize = maxsize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxsize;
        }
    }
}

