/*
 * Decompiled with CFR 0.152.
 */
package lux.compiler;

import lux.exception.LuxException;
import lux.index.IndexConfiguration;
import lux.query.BooleanPQuery;
import lux.query.MatchAllPQuery;
import lux.query.ParseableQuery;
import lux.query.SpanBooleanPQuery;
import lux.query.SpanMatchAll;
import lux.query.SpanNearPQuery;
import lux.xml.ValueType;
import lux.xpath.AbstractExpression;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.SortField;

public class XPathQuery {
    private final ParseableQuery pquery;
    private ValueType valueType;
    private final boolean immutable;
    private long facts;
    private XPathQuery baseQuery;
    private SortField[] sortFields;
    public static final int EXACT = 1;
    public static final int MINIMAL = 2;
    public static final int SINGULAR = 4;
    public static final int BOOLEAN_FALSE = 16;
    public static final int IGNORABLE = 32;
    public static final int EMPTY = 64;
    public static final XPathQuery MATCH_ALL = new XPathQuery(MatchAllPQuery.getInstance(), 70L, ValueType.DOCUMENT, true);
    private static final XPathQuery PATH_MATCH_ALL = new XPathQuery(SpanMatchAll.getInstance(), 70L, ValueType.DOCUMENT, true);

    public SortField[] getSortFields() {
        return this.sortFields;
    }

    public void setSortFields(SortField[] sortFields) {
        this.sortFields = sortFields;
        if (sortFields != null) {
            this.setFact(32, false);
        }
    }

    protected XPathQuery(ParseableQuery query, long resultFacts, ValueType valueType, boolean immutable) {
        this.pquery = query;
        this.facts = resultFacts;
        this.setType(valueType);
        this.immutable = immutable;
    }

    protected XPathQuery(ParseableQuery query, long resultFacts, ValueType valueType) {
        this(query, resultFacts, valueType, false);
    }

    public static XPathQuery getQuery(ParseableQuery query, long resultFacts, ValueType valueType, IndexConfiguration indexConfig, SortField[] sortFields) {
        XPathQuery q = new XPathQuery(query, resultFacts, valueType);
        q.setSortFields(sortFields);
        return q;
    }

    public static XPathQuery getMatchAllQuery(IndexConfiguration indexConfig) {
        if (indexConfig.isOption(64)) {
            return PATH_MATCH_ALL;
        }
        return MATCH_ALL;
    }

    public ParseableQuery getParseableQuery() {
        return this.pquery;
    }

    public boolean isMinimal() {
        return (this.facts & 2L) != 0L;
    }

    public ValueType getResultType() {
        return this.valueType;
    }

    public XPathQuery combineBooleanQueries(BooleanClause.Occur occur, XPathQuery precursor, BooleanClause.Occur precursorOccur, ValueType type, IndexConfiguration config) {
        if (this.isFact(32)) {
            if (precursor.isFact(32)) {
                precursorOccur = occur = BooleanClause.Occur.SHOULD;
            }
            if (this.isEmpty() && this.isMinimal()) {
                return precursor;
            }
            return precursor.setFact(2, false);
        }
        if (precursor.isFact(32)) {
            if (precursor.isEmpty() && precursor.isMinimal()) {
                return this;
            }
            return this.setFact(2, false);
        }
        long resultFacts = XPathQuery.combineQueryFacts(this, precursor);
        ParseableQuery result = XPathQuery.combineBoolean(this.pquery, occur, precursor.pquery, precursorOccur);
        SortField[] combined = this.combineSortFields(precursor);
        return XPathQuery.getQuery(result, resultFacts, type, config, combined);
    }

    private SortField[] combineSortFields(XPathQuery precursor) {
        if (this.sortFields != null) {
            if (precursor.sortFields != null) {
                SortField[] combined = new SortField[this.sortFields.length + precursor.sortFields.length];
                System.arraycopy(this.sortFields, 0, combined, 0, this.sortFields.length);
                System.arraycopy(precursor.sortFields, 0, combined, this.sortFields.length, precursor.sortFields.length);
                return combined;
            }
            return this.sortFields;
        }
        if (precursor.sortFields != null) {
            return precursor.sortFields;
        }
        return null;
    }

    public XPathQuery combineSpanQueries(XPathQuery precursor, BooleanClause.Occur occur, ValueType type, int distance, IndexConfiguration config) {
        if (this.isFact(32)) {
            XPathQuery result = precursor.setFact(2, false);
            if (type != null) {
                result.setType(type);
            }
            return result;
        }
        if (precursor.isFact(32)) {
            XPathQuery result = this.setFact(2, false);
            if (type != null) {
                result.setType(type);
            }
            return result;
        }
        long resultFacts = XPathQuery.combineQueryFacts(this, precursor);
        ParseableQuery result = XPathQuery.combineSpans(this.pquery, occur, precursor.pquery, distance);
        SortField[] combinedSorts = this.combineSortFields(precursor);
        XPathQuery q = new XPathQuery(result, resultFacts, type);
        q.setSortFields(combinedSorts);
        if (this.baseQuery != null) {
            if (precursor.getBaseQuery() != null) {
                q.setBaseQuery(this.baseQuery.combineBooleanQueries(occur, precursor.getBaseQuery(), occur, this.baseQuery.getResultType(), config));
            } else {
                q.setBaseQuery(this.baseQuery);
            }
        } else if (precursor.getBaseQuery() != null) {
            q.setBaseQuery(precursor.getBaseQuery());
        }
        return q;
    }

    private static long combineQueryFacts(XPathQuery a, XPathQuery b) {
        if (b.isEmpty()) {
            return a.facts;
        }
        if (a.isEmpty()) {
            return b.facts;
        }
        return XPathQuery.combineFacts(a.facts, b.facts);
    }

    private static ParseableQuery combineBoolean(ParseableQuery a, BooleanClause.Occur aOccur, ParseableQuery b, BooleanClause.Occur bOccur) {
        if (a instanceof MatchAllPQuery && bOccur != BooleanClause.Occur.MUST_NOT) {
            return b;
        }
        if (b instanceof MatchAllPQuery && aOccur != BooleanClause.Occur.MUST_NOT) {
            return a;
        }
        if (a == null || a.equals(b)) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new BooleanPQuery(new BooleanPQuery.Clause(a, aOccur), new BooleanPQuery.Clause(b, bOccur));
    }

    private static ParseableQuery combineSpans(ParseableQuery a, BooleanClause.Occur occur, ParseableQuery b, int distance) {
        if (distance == 0) {
            return XPathQuery.combineFiniteSpan(a, occur, b, distance);
        }
        if (a instanceof SpanMatchAll && occur != BooleanClause.Occur.MUST_NOT && (distance > 90 || distance < 0)) {
            if (occur == BooleanClause.Occur.SHOULD) {
                return a;
            }
            return b;
        }
        if (b instanceof SpanMatchAll) {
            if (occur == BooleanClause.Occur.SHOULD) {
                return b;
            }
            return a;
        }
        if (distance > 0) {
            return XPathQuery.combineFiniteSpan(a, occur, b, distance);
        }
        if (a.equals(b)) {
            return a;
        }
        return new SpanBooleanPQuery(occur, a, b);
    }

    private static ParseableQuery combineFiniteSpan(ParseableQuery a, BooleanClause.Occur occur, ParseableQuery b, int distance) {
        if (occur != BooleanClause.Occur.MUST) {
            throw new IllegalArgumentException("unsupported boolean combination for span query: " + occur);
        }
        assert (!(a instanceof SpanBooleanPQuery) || !(b instanceof SpanBooleanPQuery));
        if (a instanceof SpanBooleanPQuery && ((SpanBooleanPQuery)a).getOccur() == BooleanClause.Occur.MUST || b instanceof SpanBooleanPQuery && ((SpanBooleanPQuery)b).getOccur() == BooleanClause.Occur.MUST) {
            return XPathQuery.combineBooleanWithSpan(a, b, distance);
        }
        return new SpanNearPQuery(distance, true, a, b);
    }

    private static ParseableQuery combineBooleanWithSpan(ParseableQuery a, ParseableQuery b, int distance) {
        SpanBooleanPQuery bq = (SpanBooleanPQuery)(a instanceof SpanBooleanPQuery ? a : b);
        BooleanPQuery.Clause[] clauses = new BooleanPQuery.Clause[bq.getClauses().length];
        System.arraycopy(bq.getClauses(), 0, clauses, 0, clauses.length);
        int i = clauses.length - 1;
        clauses[i] = bq == a ? new BooleanPQuery.Clause(new SpanNearPQuery(distance, true, clauses[i].getQuery(), b), clauses[i].getOccur()) : new BooleanPQuery.Clause(new SpanNearPQuery(distance, true, a, clauses[i].getQuery()), clauses[i].getOccur());
        return new SpanBooleanPQuery(clauses);
    }

    private static final long combineFacts(long facts2, long facts3) {
        return facts2 & facts3;
    }

    public boolean isEmpty() {
        return this.isFact(64);
    }

    public String toString() {
        return this.pquery == null ? "" : this.pquery.toString();
    }

    public XPathQuery setFact(int fact, boolean t) {
        XPathQuery query = this;
        if (this.immutable) {
            query = new XPathQuery(this.pquery, this.facts, this.valueType);
        }
        query.facts = t ? (query.facts |= (long)fact) : (query.facts &= (long)(~fact));
        return query;
    }

    public final boolean isFact(int fact) {
        return (this.facts & (long)fact) == (long)fact;
    }

    public long getFacts() {
        return this.facts;
    }

    public void setType(ValueType type) {
        if (this.immutable) {
            throw new LuxException("attempt to modify immutable query");
        }
        if (type == null) {
            type = ValueType.VALUE;
        }
        this.valueType = type;
        this.facts &= 0xFFFFFFFFFFFFFFEFL;
        if (this.valueType == ValueType.BOOLEAN) {
            this.facts &= 0xFFFFFFFFFFFFFFFBL;
        } else if (this.valueType == ValueType.BOOLEAN_FALSE) {
            this.facts |= 0x10L;
            this.facts &= 0xFFFFFFFFFFFFFFFBL;
        } else if (this.valueType == ValueType.DOCUMENT) {
            this.facts |= 4L;
        }
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public AbstractExpression toXmlNode(String defaultField, IndexConfiguration config) {
        return this.getParseableQuery().toXmlNode(defaultField, config);
    }

    public XPathQuery getBaseQuery() {
        return this.baseQuery;
    }

    public void setBaseQuery(XPathQuery baseQuery) {
        this.baseQuery = baseQuery;
    }
}

