/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import java.io.IOException;
import lux.Evaluator;
import lux.functions.SearchBase;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;

public class Count
extends SearchBase {
    public StructuredQName getFunctionQName() {
        return new StructuredQName("lux", "http://luxdb.net", "count");
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_INTEGER;
    }

    public boolean trustResultType() {
        return true;
    }

    public UnfailingIterator<Int64Value> iterate(Query query, Evaluator saxon, long facts, String sortCriteria, int start) throws XPathException {
        int count = 0;
        long t = System.currentTimeMillis();
        try {
            DocIdSetIterator counter = saxon.getSearcher().search(query);
            while (counter.nextDoc() != Integer.MAX_VALUE) {
                ++count;
            }
        }
        catch (IOException e) {
            throw new XPathException((Throwable)e);
        }
        saxon.getQueryStats().totalTime = System.currentTimeMillis() - t;
        saxon.getQueryStats().docCount += count;
        return SingletonIterator.makeIterator((Item)new Int64Value((long)count));
    }
}

