/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import javax.xml.stream.XMLStreamException;
import lux.Evaluator;
import lux.functions.NamespaceAwareFunctionCall;
import lux.functions.SearchBase;
import lux.index.IndexConfiguration;
import lux.search.highlight.TagFormatter;
import lux.search.highlight.XmlHighlighter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.search.Query;

public class Highlight
extends ExtensionFunctionDefinition {
    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_NODE, SequenceType.SINGLE_ITEM, SequenceType.SINGLE_ITEM};
    }

    public StructuredQName getFunctionQName() {
        return new StructuredQName("lux", "http://luxdb.net", "highlight");
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.makeSequenceType((ItemType)NodeKindTest.DOCUMENT, (int)24576);
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new HighlightCall();
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    class HighlightCall
    extends NamespaceAwareFunctionCall {
        HighlightCall() {
        }

        public SequenceIterator<? extends Item> call(SequenceIterator<? extends Item>[] arguments, XPathContext context) throws XPathException {
            TagFormatter formatter;
            Query query;
            NodeInfo docArg = (NodeInfo)arguments[0].next();
            if (docArg == null) {
                return EmptyIterator.emptyIterator();
            }
            Item queryArg = arguments[1].next();
            Evaluator eval = SearchBase.getEvaluator(context);
            try {
                query = this.parseQuery(queryArg, eval);
            }
            catch (ParseException e) {
                throw new XPathException(e.getMessage(), (Throwable)e);
            }
            catch (ParserException e) {
                throw new XPathException("Failed to parse xml query : " + e.getMessage(), (Throwable)e);
            }
            IndexConfiguration indexConfiguration = eval.getCompiler().getIndexConfiguration();
            if (arguments.length < 3) {
                formatter = new TagFormatter("B", null);
            } else {
                Item tagName = arguments[2].next();
                if (tagName instanceof QualifiedNameValue) {
                    QualifiedNameValue qname = (QualifiedNameValue)tagName;
                    formatter = new TagFormatter(qname.getLocalName(), qname.getNamespaceURI());
                } else if (tagName instanceof StringValue) {
                    formatter = new TagFormatter(tagName.getStringValue(), null);
                } else {
                    throw new XPathException("invalid tag name for lux:highlight: got a " + tagName.getClass().getSimpleName() + " when expecting a QName or string");
                }
            }
            XmlHighlighter xmlHighlighter = new XmlHighlighter(eval.getCompiler().getProcessor(), indexConfiguration, formatter);
            try {
                XdmNode highlighted = xmlHighlighter.highlight(query, docArg);
                return SingletonIterator.makeIterator((Item)highlighted.getUnderlyingNode());
            }
            catch (XMLStreamException e) {
                throw new XPathException((Throwable)e);
            }
            catch (SaxonApiException e) {
                throw new XPathException((Throwable)e);
            }
        }
    }
}

