/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import lux.Evaluator;
import lux.TransformErrorListener;
import lux.functions.NamespaceAwareFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.search.Query;
import org.slf4j.LoggerFactory;

public abstract class SearchBase
extends ExtensionFunctionDefinition {
    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_ITEM, SequenceType.OPTIONAL_INTEGER};
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new SearchCall();
    }

    public static Evaluator getEvaluator(XPathContext context) {
        TransformErrorListener listener = (TransformErrorListener)context.getController().getErrorListener();
        return (Evaluator)listener.getUserData();
    }

    protected abstract SequenceIterator<? extends Item> iterate(Query var1, Evaluator var2, long var3, String var5, int var6) throws XPathException;

    public class SearchCall
    extends NamespaceAwareFunctionCall {
        public SequenceIterator<? extends Item> call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            Query query;
            Item startArg;
            Item sortArg;
            IntegerValue num;
            if (arguments.length == 0 || arguments.length > 4) {
                throw new XPathException("wrong number of arguments for " + SearchBase.this.getFunctionQName());
            }
            Item queryArg = arguments[0].next();
            long facts = 0L;
            if (arguments.length >= 2 && (num = (IntegerValue)arguments[1].next()) != null) {
                facts = num.longValue();
            }
            String sortCriteria = null;
            if (arguments.length >= 3 && (sortArg = arguments[2].next()) != null) {
                sortCriteria = sortArg.getStringValue();
            }
            int start = 1;
            if (arguments.length >= 4 && (startArg = arguments[3].next()) != null) {
                IntegerValue integerValue = (IntegerValue)startArg;
                if (integerValue.longValue() > Integer.MAX_VALUE) {
                    throw new XPathException("integer overflow in search $start parameter");
                }
                start = (int)integerValue.longValue();
            }
            Evaluator eval = SearchBase.getEvaluator(context);
            try {
                query = this.parseQuery(queryArg, eval);
            }
            catch (ParseException e) {
                throw new XPathException(e.getMessage(), (Throwable)e);
            }
            catch (ParserException e) {
                throw new XPathException("Failed to parse xml query : " + e.getMessage(), (Throwable)e);
            }
            LoggerFactory.getLogger(SearchBase.class).debug("executing query: {}", (Object)query);
            return SearchBase.this.iterate(query, eval, facts, sortCriteria, start);
        }
    }
}

