/*
 * Decompiled with CFR 0.152.
 */
package lux.query;

import java.util.ArrayList;
import lux.index.IndexConfiguration;
import lux.query.ParseableQuery;
import lux.xml.QName;
import lux.xpath.AbstractExpression;
import lux.xpath.LiteralExpression;
import lux.xpath.Sequence;
import lux.xquery.AttributeConstructor;
import lux.xquery.ElementConstructor;
import org.apache.lucene.search.BooleanClause;

public class BooleanPQuery
extends ParseableQuery {
    public static final QName BOOLEAN_QUERY_QNAME = new QName("BooleanQuery");
    public static final QName CLAUSE_QNAME = new QName("Clause");
    public static final LiteralExpression OCCURS_ATT_NAME = new LiteralExpression("occurs");
    public static final AttributeConstructor MUST_OCCUR_ATT = new AttributeConstructor(OCCURS_ATT_NAME, new LiteralExpression("must"));
    public static final AttributeConstructor SHOULD_OCCUR_ATT = new AttributeConstructor(OCCURS_ATT_NAME, new LiteralExpression("should"));
    public static final AttributeConstructor MUST_NOT_OCCUR_ATT = new AttributeConstructor(OCCURS_ATT_NAME, new LiteralExpression("mustNot"));
    private Clause[] clauses;

    public BooleanPQuery(Clause ... clauses) {
        BooleanClause.Occur oc = clauses[0].getOccur();
        ArrayList<Clause> cl = new ArrayList<Clause>();
        for (Clause clause : clauses) {
            BooleanPQuery bq;
            ParseableQuery query = clause.getQuery();
            if (query instanceof BooleanPQuery && (bq = (BooleanPQuery)query).getOccur() == oc) {
                for (Clause subclause : bq.getClauses()) {
                    cl.add(subclause);
                }
                continue;
            }
            cl.add(clause);
        }
        this.clauses = cl.toArray(new Clause[cl.size()]);
    }

    public BooleanPQuery(BooleanClause.Occur occur, ParseableQuery ... queries) {
        this.clauses = new Clause[queries.length];
        int i = 0;
        for (ParseableQuery query : queries) {
            this.clauses[i++] = new Clause(query, occur);
        }
    }

    public BooleanClause.Occur getOccur() {
        return this.clauses.length > 0 ? this.clauses[0].occur : BooleanClause.Occur.SHOULD;
    }

    public Clause[] getClauses() {
        return this.clauses;
    }

    @Override
    public ElementConstructor toXmlNode(String field, IndexConfiguration config) {
        if (this.clauses.length == 1 && this.clauses[0].occur == BooleanClause.Occur.MUST) {
            return this.clauses[0].getQuery().toXmlNode(field, config);
        }
        AbstractExpression[] clauseExprs = new AbstractExpression[this.clauses.length];
        int i = 0;
        for (Clause clause : this.clauses) {
            ElementConstructor q = clause.getQuery().toXmlNode(field, config);
            AttributeConstructor occurAtt = null;
            if (clause.occur == BooleanClause.Occur.MUST) {
                occurAtt = MUST_OCCUR_ATT;
            } else if (clause.occur == BooleanClause.Occur.SHOULD) {
                occurAtt = SHOULD_OCCUR_ATT;
            } else if (clause.occur == BooleanClause.Occur.MUST_NOT) {
                occurAtt = MUST_NOT_OCCUR_ATT;
            }
            clauseExprs[i++] = new ElementConstructor(CLAUSE_QNAME, q, occurAtt);
        }
        return new ElementConstructor(BOOLEAN_QUERY_QNAME, new Sequence(clauseExprs), new AttributeConstructor[0]);
    }

    @Override
    public String toQueryString(String field, IndexConfiguration config) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.clauses.length; ++i) {
            Clause c = this.clauses[i];
            if (c.occur == BooleanClause.Occur.MUST_NOT) {
                buf.append("-");
            } else if (c.occur == BooleanClause.Occur.MUST) {
                buf.append("+");
            }
            ParseableQuery subq = c.getQuery();
            if (subq != null) {
                if (subq instanceof BooleanPQuery) {
                    buf.append('(').append(subq.toQueryString(field, config)).append(')');
                } else {
                    buf.append(subq.toQueryString(field, config));
                }
            }
            if (i >= this.clauses.length - 1) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public static class Clause {
        private final BooleanClause.Occur occur;
        private final ParseableQuery query;

        public Clause(ParseableQuery query, BooleanClause.Occur occur) {
            this.occur = occur;
            this.query = query;
        }

        public BooleanClause.Occur getOccur() {
            return this.occur;
        }

        public String getOccurAttribute() {
            switch (this.occur) {
                case MUST: {
                    return "must";
                }
                case SHOULD: {
                    return "should";
                }
                case MUST_NOT: {
                    return "mustNot";
                }
            }
            return "";
        }

        public ParseableQuery getQuery() {
            return this.query;
        }
    }
}

