/*
 * Decompiled with CFR 0.152.
 */
package lux.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;

public class LuxSearcher
extends IndexSearcher {
    private final IndexReader indexReader;

    public LuxSearcher(Directory dir) throws IOException {
        super((IndexReader)DirectoryReader.open((Directory)dir));
        this.indexReader = this.getIndexReader();
    }

    public LuxSearcher(IndexSearcher searcher) {
        super(searcher.getIndexReader());
        this.indexReader = null;
    }

    public LuxSearcher(IndexReader reader) {
        super(reader);
        this.indexReader = reader;
    }

    public void close() throws IOException {
        if (this.indexReader != null) {
            this.indexReader.close();
        }
    }

    public DocIdSetIterator search(Query query) throws IOException {
        return new DocIterator(query, false);
    }

    public DocIdSetIterator search(Query query, Sort sort) throws IOException {
        return new TopDocsIterator(query, sort);
    }

    public DocIdSetIterator searchOrdered(Query query) throws IOException {
        return new DocIterator(query, true);
    }

    class TopDocsIterator
    extends DocIdSetIterator {
        private final Query query;
        private final Sort sort;
        private int docID = -1;
        private int iDocNext = 0;
        private TopDocs topDocs;
        private static final int BATCH_SIZE = 200;

        TopDocsIterator(Query query, Sort sort) throws IOException {
            this.query = query;
            this.sort = sort;
            this.topDocs = LuxSearcher.this.search(LuxSearcher.this.createNormalizedWeight(query), 200, sort, false, false);
        }

        public int docID() {
            return this.docID;
        }

        public int nextDoc() throws IOException {
            if (this.iDocNext < this.topDocs.scoreDocs.length) {
                this.docID = this.topDocs.scoreDocs[this.iDocNext++].doc;
            } else if (this.iDocNext < this.topDocs.totalHits) {
                this.topDocs = LuxSearcher.this.search(LuxSearcher.this.createNormalizedWeight(this.query), this.iDocNext + 200, this.sort, false, false);
            } else {
                this.docID = Integer.MAX_VALUE;
            }
            return this.docID;
        }

        public int advance(int target) throws IOException {
            return Integer.MAX_VALUE;
        }
    }

    class DocIterator
    extends DocIdSetIterator {
        private final Weight weight;
        private final boolean ordered;
        private int nextReader;
        private int docID;
        private Scorer scorer;
        private List<AtomicReaderContext> leaves;
        private AtomicReaderContext leaf;

        DocIterator(Query query, boolean ordered) throws IOException {
            this.weight = LuxSearcher.this.createNormalizedWeight(query);
            this.leaves = LuxSearcher.this.getIndexReader().leaves();
            this.ordered = ordered;
            this.nextReader = 0;
            this.docID = -1;
            this.advanceScorer();
        }

        private void advanceScorer() throws IOException {
            while (this.nextReader < this.leaves.size()) {
                this.leaf = this.leaves.get(this.nextReader++);
                this.scorer = this.weight.scorer(this.leaf, this.ordered, false, this.leaf.reader().getLiveDocs());
                if (this.scorer == null) continue;
                return;
            }
            this.scorer = null;
        }

        public int docID() {
            return this.docID;
        }

        public int nextDoc() throws IOException {
            while (this.scorer != null) {
                this.docID = this.scorer.nextDoc();
                if (this.docID != Integer.MAX_VALUE) {
                    return this.docID + this.leaf.docBase;
                }
                this.advanceScorer();
            }
            return Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            while (this.scorer != null) {
                this.docID = this.scorer.advance(target - this.leaf.docBase);
                if (this.docID != Integer.MAX_VALUE) {
                    return this.docID + this.leaf.docBase;
                }
                this.advanceScorer();
            }
            return Integer.MAX_VALUE;
        }
    }
}

