/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import lux.DocWriter;
import lux.exception.LuxException;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.XmlIndexer;
import lux.solr.UpdateDocCommand;
import lux.solr.XQueryComponent;
import lux.xml.tinybin.TinyBinary;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.UpdateHandler;

public class SolrDocWriter
implements DocWriter {
    private final SolrCore core;
    private final XQueryComponent xqueryComponent;
    private final String uriFieldName;
    private final String xmlFieldName;

    SolrDocWriter(XQueryComponent xQueryComponent, SolrCore core) {
        this.core = core;
        this.xqueryComponent = xQueryComponent;
        IndexConfiguration indexConfig = xQueryComponent.getSolrIndexConfig().getIndexConfig();
        this.uriFieldName = indexConfig.getFieldName(FieldName.URI);
        this.xmlFieldName = indexConfig.getFieldName(FieldName.XML_STORE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(NodeInfo node, String uri) {
        XmlIndexer indexer = null;
        try {
            indexer = this.xqueryComponent.getSolrIndexConfig().checkoutXmlIndexer();
            try {
                indexer.index(node, uri);
            }
            catch (XMLStreamException e) {
                throw new LuxException(e);
            }
            UpdateDocCommand cmd = new UpdateDocCommand(this.core, indexer.createLuceneDocument(), uri);
            UpdateHandler updateHandler = this.core.getUpdateHandler();
            if (updateHandler.getUpdateLog() != null) {
                SolrInputDocument solrDoc = new SolrInputDocument();
                solrDoc.addField(this.uriFieldName, (Object)uri);
                if (node instanceof TinyNodeImpl) {
                    TinyBinary tinybin = new TinyBinary(((TinyNodeImpl)node).getTree());
                    solrDoc.addField(this.xmlFieldName, (Object)tinybin.getByteBuffer());
                } else {
                    String xml = node.toString();
                    solrDoc.addField(this.xmlFieldName, (Object)xml);
                }
                cmd.solrDoc = solrDoc;
            }
            try {
                updateHandler.addDoc((AddUpdateCommand)cmd);
            }
            catch (IOException e) {
                throw new LuxException(e);
            }
        }
        finally {
            if (indexer != null) {
                this.xqueryComponent.getSolrIndexConfig().returnXmlIndexer(indexer);
            }
        }
    }

    @Override
    public void delete(String uri) {
        DeleteUpdateCommand cmd = new DeleteUpdateCommand((SolrQueryRequest)this.makeSolrQueryRequest());
        cmd.id = uri;
        try {
            this.core.getUpdateHandler().delete(cmd);
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }

    @Override
    public void deleteAll() {
        DeleteUpdateCommand cmd = new DeleteUpdateCommand((SolrQueryRequest)this.makeSolrQueryRequest());
        cmd.query = "*:*";
        try {
            this.core.getUpdateHandler().deleteByQuery(cmd);
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }

    private SolrQueryRequestBase makeSolrQueryRequest() {
        return new SolrQueryRequestBase(this.core, (SolrParams)new ModifiableSolrParams()){};
    }

    @Override
    public void commit() {
        CommitUpdateCommand cmd = new CommitUpdateCommand((SolrQueryRequest)this.makeSolrQueryRequest(), false);
        cmd.expungeDeletes = false;
        cmd.waitSearcher = true;
        try {
            this.core.getUpdateHandler().commit(cmd);
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }

    @Override
    public void close() {
        this.commit();
    }
}

