/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import lux.xpath.ExpressionVisitor;
import lux.xpath.Visitable;
import lux.xquery.VariableContext;

public abstract class AbstractExpression
implements Visitable {
    protected AbstractExpression sup;
    protected AbstractExpression[] subs;
    private final Type type;

    protected AbstractExpression(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void acceptSubs(ExpressionVisitor visitor) {
        for (int i = 0; i < this.subs.length && !visitor.isDone(); ++i) {
            int j = visitor.isReverse() ? this.subs.length - i - 1 : i;
            AbstractExpression sub = this.subs[j].accept(visitor);
            if (sub == this.subs[j]) continue;
            this.subs[j] = sub;
        }
    }

    public AbstractExpression getSuper() {
        return this.sup;
    }

    public AbstractExpression[] getSubs() {
        return this.subs;
    }

    protected void setSubs(AbstractExpression ... subExprs) {
        for (AbstractExpression sub : this.subs = subExprs) {
            sub.sup = this;
        }
    }

    public abstract void toString(StringBuilder var1);

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    public AbstractExpression getRoot() {
        return null;
    }

    public boolean isAbsolute() {
        return this.getRoot() != null;
    }

    public boolean isDocumentOrdered() {
        if (this.subs != null) {
            for (AbstractExpression sub : this.subs) {
                if (sub.isDocumentOrdered()) continue;
                return false;
            }
        }
        return true;
    }

    public AbstractExpression replaceRoot(AbstractExpression replacement) {
        if (this.subs != null) {
            for (int i = 0; i < this.subs.length; ++i) {
                AbstractExpression replaced = this.subs[i].replaceRoot(replacement);
                if (replaced == this.subs[i]) continue;
                this.subs[i] = replaced;
            }
        }
        return this;
    }

    protected void appendSub(StringBuilder buf, AbstractExpression sub) {
        if (sub.getPrecedence() <= this.getPrecedence()) {
            buf.append('(');
            sub.toString(buf);
            buf.append(')');
        } else {
            sub.toString(buf);
        }
    }

    public AbstractExpression getTail() {
        return null;
    }

    public AbstractExpression getLastContextStep() {
        return this;
    }

    public VariableContext getBindingContext() {
        return null;
    }

    public abstract int getPrecedence();

    public static enum Type {
        PATH_EXPRESSION,
        PATH_STEP,
        PREDICATE,
        BINARY_OPERATION,
        SET_OPERATION,
        LITERAL,
        ROOT,
        DOT,
        FUNCTION_CALL,
        SEQUENCE,
        UNARY_MINUS,
        SUBSEQUENCE,
        LET,
        VARIABLE,
        COMPUTED_ELEMENT,
        ELEMENT,
        ATTRIBUTE,
        TEXT,
        FLWOR,
        CONDITIONAL,
        COMMENT,
        DOCUMENT_CONSTRUCTOR,
        PROCESSING_INSTRUCTION,
        SATISFIES,
        INSTANCE_OF,
        CASTABLE,
        TREAT;

    }
}

