/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import lux.xml.ValueType;
import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;

public class BinaryOperation
extends AbstractExpression {
    private final Operator operator;

    public BinaryOperation(AbstractExpression op1, Operator operator, AbstractExpression op2) {
        super(AbstractExpression.Type.BINARY_OPERATION);
        this.setSubs(op1, op2);
        this.operator = operator;
    }

    @Override
    public void toString(StringBuilder buf) {
        this.appendSub(buf, this.subs[0]);
        buf.append(' ').append((Object)this.operator).append(' ');
        this.appendSub(buf, this.subs[1]);
    }

    public AbstractExpression getOperand1() {
        return this.subs[0];
    }

    public AbstractExpression getOperand2() {
        return this.subs[1];
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        super.acceptSubs(visitor);
        return visitor.visit(this);
    }

    @Override
    public boolean isDocumentOrdered() {
        return this.operator.getResultType().isNode && super.isDocumentOrdered();
    }

    @Override
    public int getPrecedence() {
        return this.operator.precedence;
    }

    public static enum Operator {
        AND("and", ValueType.BOOLEAN, 5),
        OR("or", ValueType.BOOLEAN, 4),
        INTERSECT("intersect", ValueType.VALUE, 11),
        EXCEPT("except", ValueType.VALUE, 11),
        UNION("|", ValueType.VALUE, 10),
        ADD("+", ValueType.ATOMIC, 8),
        SUB("-", ValueType.ATOMIC, 8),
        MUL("*", ValueType.ATOMIC, 9),
        DIV("div", ValueType.ATOMIC, 9),
        IDIV("idiv", ValueType.ATOMIC, 9),
        MOD("mod", ValueType.ATOMIC, 9),
        EQUALS("=", ValueType.BOOLEAN, 6),
        NE("!=", ValueType.BOOLEAN, 6),
        LT("<", ValueType.BOOLEAN, 6),
        GT(">", ValueType.BOOLEAN, 6),
        LE("<=", ValueType.BOOLEAN, 6),
        GE(">=", ValueType.BOOLEAN, 6),
        AEQ("eq", ValueType.BOOLEAN, 6),
        ANE("ne", ValueType.BOOLEAN, 6),
        ALT("lt", ValueType.BOOLEAN, 6),
        ALE("le", ValueType.BOOLEAN, 6),
        AGT("gt", ValueType.BOOLEAN, 6),
        AGE("ge", ValueType.BOOLEAN, 6),
        IS("is", ValueType.BOOLEAN, 6),
        BEFORE("<<", ValueType.BOOLEAN, 6),
        AFTER(">>", ValueType.BOOLEAN, 6),
        TO("to", ValueType.ATOMIC, 7);

        private String token;
        private ValueType resultType;
        private int precedence;

        private Operator(String token, ValueType resultType, int precedence) {
            this.token = token;
            this.resultType = resultType;
            this.precedence = precedence;
        }

        public String toString() {
            return this.token;
        }

        public ValueType getResultType() {
            return this.resultType;
        }

        public int getPrecedence() {
            return this.precedence;
        }
    }
}

