/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import java.math.BigDecimal;
import javax.xml.bind.DatatypeConverter;
import lux.exception.LuxException;
import lux.xml.QName;
import lux.xml.ValueType;
import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;

public class LiteralExpression
extends AbstractExpression {
    private final Object value;
    private final ValueType valueType;
    public static final LiteralExpression EMPTY = new LiteralExpression("()", ValueType.EMPTY);
    public static final LiteralExpression ONE = new LiteralExpression(1L);
    private static char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public LiteralExpression(Object value, ValueType valueType) {
        super(AbstractExpression.Type.LITERAL);
        this.value = value;
        this.valueType = valueType;
    }

    public LiteralExpression(Object value) {
        super(AbstractExpression.Type.LITERAL);
        this.value = value;
        this.valueType = value != null ? LiteralExpression.computeType(value) : ValueType.VALUE;
    }

    private static ValueType computeType(Object value) {
        if (value instanceof String) {
            return ValueType.STRING;
        }
        if (value instanceof Integer || value instanceof Long) {
            return ValueType.INTEGER;
        }
        if (value instanceof Double) {
            return ValueType.DOUBLE;
        }
        if (value instanceof Float) {
            return ValueType.FLOAT;
        }
        if (value instanceof BigDecimal) {
            return ValueType.DECIMAL;
        }
        if (value instanceof Boolean) {
            return ValueType.BOOLEAN;
        }
        if (value instanceof QName) {
            return ValueType.QNAME;
        }
        throw new LuxException("unsupported java object type: " + value.getClass().getSimpleName());
    }

    @Override
    public int getPrecedence() {
        return 100;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void toString(StringBuilder buf) {
        if (this.value == null) {
            buf.append("()");
            return;
        }
        switch (this.valueType) {
            case UNTYPED_ATOMIC: {
                buf.append("xs:untypedAtomic(");
                LiteralExpression.quoteString(this.value.toString(), buf);
                buf.append(')');
                break;
            }
            case STRING: {
                LiteralExpression.quoteString(this.value.toString(), buf);
                break;
            }
            case BOOLEAN: {
                buf.append("fn:").append(this.value).append("()");
                break;
            }
            case FLOAT: {
                Float f = (Float)this.value;
                if (f.isInfinite()) {
                    if (f.floatValue() > 0.0f) {
                        buf.append("xs:float('INF')");
                        break;
                    }
                    buf.append("xs:float('-INF')");
                    break;
                }
                if (f.isNaN()) {
                    buf.append("xs:float('NaN')");
                    break;
                }
                buf.append("xs:float(").append(f).append(')');
                break;
            }
            case DOUBLE: {
                Double d = (Double)this.value;
                if (d.isInfinite()) {
                    if (d > 0.0) {
                        buf.append("xs:double('INF')");
                        break;
                    }
                    buf.append("xs:double('-INF')");
                    break;
                }
                if (d.isNaN()) {
                    buf.append("xs:double('NaN')");
                    break;
                }
                buf.append("xs:double(").append(d).append(')');
                break;
            }
            case DECIMAL: {
                buf.append("xs:decimal(").append(((BigDecimal)this.value).toPlainString()).append(")");
                break;
            }
            case HEX_BINARY: {
                buf.append("xs:hexBinary(\"");
                this.appendHex(buf, (byte[])this.value);
                buf.append("\")");
                break;
            }
            case BASE64_BINARY: {
                buf.append("xs:base64Binary(\"");
                buf.append(DatatypeConverter.printBase64Binary((byte[])((byte[])this.value)));
                buf.append("\")");
                break;
            }
            case DATE: 
            case DATE_TIME: 
            case TIME: 
            case DAY: 
            case MONTH: 
            case MONTH_DAY: 
            case YEAR: 
            case YEAR_MONTH: {
                buf.append(this.valueType.name).append("(\"").append(this.value).append("\")");
                break;
            }
            case QNAME: {
                buf.append("fn:QName(");
                LiteralExpression.quoteString(((QName)this.value).getNamespaceURI(), buf);
                buf.append(",\"");
                ((QName)this.value).toString(buf);
                buf.append("\")");
                break;
            }
            case INT: {
                buf.append(this.valueType.name).append("(").append(this.value).append(")");
                break;
            }
            default: {
                buf.append(this.value);
            }
        }
    }

    private void appendHex(StringBuilder buf, byte[] bytes) {
        for (byte b : bytes) {
            int b1 = (b & 0xF0) >> 4;
            buf.append(hexdigits[b1]);
            int b2 = b & 0xF;
            buf.append(hexdigits[b2]);
        }
    }

    public static void escapeText(String s, StringBuilder buf) {
        block9: for (char c : s.toCharArray()) {
            switch (c) {
                case '{': {
                    buf.append("&#x7B;");
                    continue block9;
                }
                case '}': {
                    buf.append("&#x7D;");
                    continue block9;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block9;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block9;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block9;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block9;
                }
                case '\r': {
                    buf.append("&#xD;");
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
    }

    public static void quoteString(String s, StringBuilder buf) {
        buf.append('\"');
        LiteralExpression.escapeText(s, buf);
        buf.append('\"');
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object other) {
        if (other instanceof LiteralExpression) {
            return this.value.equals(((LiteralExpression)other).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

