/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;
import lux.xpath.Root;
import lux.xquery.VariableContext;

public class PathExpression
extends AbstractExpression {
    public PathExpression(AbstractExpression lhs, AbstractExpression rhs) {
        super(AbstractExpression.Type.PATH_EXPRESSION);
        this.subs = new AbstractExpression[2];
        this.setSubs(lhs, rhs);
    }

    public final AbstractExpression getRHS() {
        return this.subs[1];
    }

    public final AbstractExpression getLHS() {
        return this.subs[0];
    }

    @Override
    public int getPrecedence() {
        return 18;
    }

    @Override
    public void toString(StringBuilder buf) {
        if (!(this.subs[0] instanceof Root)) {
            this.appendSub(buf, this.subs[0]);
        }
        buf.append('/');
        this.appendSub(buf, this.subs[1]);
    }

    @Override
    public AbstractExpression getRoot() {
        return this.subs[0].getRoot();
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        this.acceptSubs(visitor);
        return visitor.visit(this);
    }

    @Override
    public AbstractExpression getTail() {
        AbstractExpression left = this.subs[0].getTail();
        if (left == null) {
            return this.subs[1];
        }
        return new PathExpression(left, this.subs[1]);
    }

    @Override
    public AbstractExpression getLastContextStep() {
        AbstractExpression expr = this.subs[1].getLastContextStep();
        if (expr.getType() == AbstractExpression.Type.PATH_STEP) {
            return expr;
        }
        return this.subs[0].getLastContextStep();
    }

    @Override
    public VariableContext getBindingContext() {
        return this.subs[0].getBindingContext();
    }
}

