/*
 * Decompiled with CFR 0.152.
 */
package lux;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import lux.DocIDNumberAllocator;
import lux.exception.LuxException;
import lux.index.IndexConfiguration;
import lux.index.field.TinyBinaryField;
import lux.xml.tinybin.TinyBinary;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;
import org.slf4j.LoggerFactory;

public class CachingDocReader {
    private static final int CACHE_RATIO = 100;
    private final NodeCache cache = new NodeCache(Runtime.getRuntime().maxMemory() / 100L);
    private final String xmlFieldName;
    private final String uriFieldName;
    private final DocumentBuilder builder;
    private final Configuration config;
    private int cacheHits = 0;
    private int cacheMisses = 0;
    private long buildTime = 0L;

    public CachingDocReader(DocumentBuilder builder, Configuration config, IndexConfiguration indexConfig) {
        this.builder = builder;
        this.config = config;
        this.xmlFieldName = indexConfig.getXmlFieldName();
        this.uriFieldName = indexConfig.getUriFieldName();
    }

    public XdmNode get(int leafDocID, AtomicReaderContext context) throws IOException {
        return this.get(leafDocID + context.docBase, leafDocID, (IndexReader)context.reader());
    }

    public XdmNode get(int docID, IndexReader reader) throws IOException {
        return this.get(docID, docID, reader);
    }

    private XdmNode get(int docID, int luceneDocID, IndexReader reader) throws IOException {
        XdmNode node = (XdmNode)this.cache.get(docID);
        if (node != null) {
            ++this.cacheHits;
            return node;
        }
        DocumentStoredFieldVisitor fieldSelector = new DocumentStoredFieldVisitor();
        reader.document(luceneDocID, (StoredFieldVisitor)fieldSelector);
        Document document = fieldSelector.getDocument();
        return this.getXdmNode(docID, document);
    }

    public XdmNode get(long docID) {
        return (XdmNode)this.cache.get(docID);
    }

    private XdmNode getXdmNode(long docID, Document document) throws IOException {
        String xml = document.get(this.xmlFieldName);
        String uri = document.get(this.uriFieldName);
        BytesRef binaryValue = document.getBinaryValue(this.xmlFieldName);
        byte[] bytes = binaryValue != null ? binaryValue.bytes : null;
        XdmNode node = this.createXdmNode(docID, uri, xml, bytes);
        document.removeField(this.xmlFieldName);
        node.getUnderlyingNode().getDocumentRoot().setUserData(Document.class.getName(), (Object)document);
        return node;
    }

    public XdmNode createXdmNode(long docID, String uri, String xml, byte[] bytes) {
        uri = "lux:/" + uri;
        DocIDNumberAllocator docIdAllocator = (DocIDNumberAllocator)this.config.getDocumentNumberAllocator();
        docIdAllocator.setNextDocID(docID);
        long t0 = System.nanoTime();
        XdmNode node = null;
        if (xml == null) {
            if (bytes == null) {
                LoggerFactory.getLogger(CachingDocReader.class).warn("Document {} has no XML content", (Object)docID);
                bytes = new byte[]{};
            }
            if (bytes.length > 4 && bytes[0] == 84 && bytes[1] == 73 && bytes[2] == 78) {
                TinyBinary tb = new TinyBinary(bytes, TinyBinaryField.UTF8);
                node = new XdmNode((NodeInfo)tb.getTinyDocument(this.config));
            } else {
                xml = "<binary xmlns=\"http://luxdb.net\" />";
            }
        }
        if (node == null) {
            StreamSource source = new StreamSource(new StringReader(xml));
            source.setSystemId(uri);
            try {
                node = this.builder.build((Source)source);
            }
            catch (SaxonApiException e) {
                throw new LuxException(e);
            }
        }
        if (bytes != null && xml == null) {
            ((TinyDocumentImpl)node.getUnderlyingNode()).setUserData("_binaryDocument", (Object)bytes);
        }
        ((TinyDocumentImpl)node.getUnderlyingNode()).setSystemId(uri);
        this.buildTime += System.nanoTime() - t0;
        this.cache.put(docID, node);
        ++this.cacheMisses;
        return node;
    }

    public int getCacheHits() {
        return this.cacheHits;
    }

    public int getCacheMisses() {
        return this.cacheMisses;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public void clear() {
        this.cache.clear();
    }

    static class NodeCache
    extends LinkedHashMap<Long, XdmNode> {
        private long bytes;
        private final long maxbytes;

        public NodeCache(long maxbytes) {
            super((int)(maxbytes / 100L * 4L / 3L + 1L), 0.75f, true);
            this.maxbytes = maxbytes;
            this.bytes = 0L;
        }

        @Override
        public XdmNode put(Long key, XdmNode value) {
            this.bytes += this.calculateSize(value);
            return super.put(key, value);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, XdmNode> eldest) {
            while (this.bytes > this.maxbytes) {
                this.remove(eldest.getKey());
                this.bytes -= this.calculateSize(eldest.getValue());
                Iterator i$ = this.entrySet().iterator();
                if (!i$.hasNext()) continue;
                Map.Entry entry = i$.next();
                eldest = entry;
            }
            return false;
        }

        private long calculateSize(XdmNode value) {
            TinyTree tree = ((TinyDocumentImpl)value.getUnderlyingNode()).getTree();
            int nodeCount = tree.getNumberOfNodes();
            int attCount = tree.getNumberOfAttributes();
            int nsCount = tree.getNumberOfNamespaces();
            byte[] binary = (byte[])((TinyDocumentImpl)value.getUnderlyingNode()).getUserData("_binaryDocument");
            int binSize = binary == null ? 0 : binary.length;
            int stringLen = 12 + 2 * nodeCount + 2 * attCount + 2 * nsCount;
            CharSequence[] attValueArray = tree.getAttributeValueArray();
            for (int i = 0; i < attCount; ++i) {
                stringLen += attValueArray[i].length();
            }
            return 36 + binSize + nodeCount * 19 + attCount * 8 + nsCount * 8 + tree.getCharacterBuffer().length() * 2 + (tree.getCommentBuffer() == null ? 0 : tree.getCommentBuffer().length() * 2) + stringLen;
        }
    }
}

