/*
 * Decompiled with CFR 0.152.
 */
package lux;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import lux.DocWriter;
import lux.Evaluator;
import lux.exception.LuxException;
import lux.index.XmlIndexer;
import net.sf.saxon.om.NodeInfo;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

public class DirectDocWriter
implements DocWriter {
    private final XmlIndexer indexer;
    private final IndexWriter indexWriter;
    private final String uriFieldName;

    public DirectDocWriter(XmlIndexer indexer, IndexWriter indexWriter) {
        this.indexer = indexer;
        this.indexWriter = indexWriter;
        this.uriFieldName = indexer.getConfiguration().getUriFieldName();
    }

    @Override
    public void write(NodeInfo node, String uri) {
        try {
            this.indexer.indexDocument(this.indexWriter, uri, node);
        }
        catch (XMLStreamException e) {
            throw new LuxException(e);
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }

    @Override
    public void delete(String uri) {
        Term term = new Term(this.uriFieldName, uri);
        try {
            this.indexWriter.deleteDocuments(term);
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }

    @Override
    public void deleteAll() {
        try {
            this.indexWriter.deleteAll();
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }

    @Override
    public void commit(Evaluator eval) {
        try {
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }

    @Override
    public void close(Evaluator eval) {
        try {
            this.indexWriter.close();
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }
}

