/*
 * Decompiled with CFR 0.152.
 */
package lux.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import lux.index.IndexConfiguration;
import lux.query.BooleanPQuery;
import lux.query.MatchAllPQuery;
import lux.query.ParseableQuery;
import lux.query.SpanBooleanPQuery;
import lux.query.SpanMatchAll;
import lux.query.SpanNearPQuery;
import lux.xml.ValueType;
import lux.xpath.AbstractExpression;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.SortField;

public class XPathQuery {
    private final ParseableQuery pquery;
    private ParseableQuery pathQuery;
    private ValueType valueType;
    private final boolean immutable;
    private long facts;
    private SortField[] sortFields;
    public static final int EXACT = 1;
    public static final int MINIMAL = 2;
    public static final int SINGULAR = 4;
    public static final int BOOLEAN_FALSE = 16;
    public static final int IGNORABLE = 32;
    public static final int EMPTY = 64;
    public static final int PATH_COMBINED = 128;
    public static final XPathQuery MATCH_ALL = new XPathQuery(MatchAllPQuery.getInstance(), MatchAllPQuery.getInstance(), 70L, ValueType.DOCUMENT, true);
    private static final XPathQuery PATH_MATCH_ALL = new XPathQuery(SpanMatchAll.getInstance(), SpanMatchAll.getInstance(), 70L, ValueType.DOCUMENT, true);

    public SortField[] getSortFields() {
        return this.sortFields;
    }

    public void setSortFields(SortField[] sortFields) {
        this.sortFields = sortFields;
        if (sortFields != null) {
            this.setFact(32, false);
        }
    }

    protected XPathQuery(ParseableQuery query, ParseableQuery pathQuery, long resultFacts, ValueType valueType, boolean immutable) {
        this.pquery = query;
        this.pathQuery = pathQuery;
        this.facts = resultFacts;
        this.setType(valueType);
        this.immutable = immutable;
    }

    protected XPathQuery(ParseableQuery query, long resultFacts, ValueType valueType, boolean immutable) {
        this(query, null, resultFacts, valueType, immutable);
    }

    protected XPathQuery(ParseableQuery query, long resultFacts, ValueType valueType) {
        this(query, resultFacts, valueType, false);
    }

    public static XPathQuery getQuery(ParseableQuery query, ParseableQuery pathQuery, long resultFacts, ValueType valueType, IndexConfiguration indexConfig, SortField[] sortFields) {
        XPathQuery q = new XPathQuery(query, resultFacts, valueType);
        q.setPathQuery(pathQuery);
        q.setSortFields(sortFields);
        return q;
    }

    public static XPathQuery getQuery(ParseableQuery termQuery, long facts, ValueType type, IndexConfiguration indexConfig, SortField[] sortFields) {
        if (termQuery.isSpanCompatible()) {
            return XPathQuery.getQuery(null, termQuery, facts, type, indexConfig, sortFields);
        }
        return XPathQuery.getQuery(termQuery, null, facts, type, indexConfig, sortFields);
    }

    public static XPathQuery getMatchAllQuery(IndexConfiguration indexConfig) {
        if (indexConfig.isOption(64)) {
            return PATH_MATCH_ALL;
        }
        return MATCH_ALL;
    }

    public boolean isMinimal() {
        return (this.facts & 2L) != 0L;
    }

    public ValueType getResultType() {
        return this.valueType;
    }

    public XPathQuery combineBooleanQueries(BooleanClause.Occur occur, XPathQuery precursor, BooleanClause.Occur precursorOccur, ValueType type, IndexConfiguration config) {
        XPathQuery result = this.combineIgnorableQueries(occur, precursor);
        if (result != null) {
            return result;
        }
        long resultFacts = XPathQuery.combineQueryFacts(this, precursor);
        ParseableQuery combined = XPathQuery.combineBoolean(this.pquery, occur, precursor.pquery, precursorOccur);
        SortField[] combinedSorts = this.combineSortFields(precursor);
        XPathQuery q = XPathQuery.getQuery(combined, null, resultFacts, type, config, combinedSorts);
        q.setPathQuery(this.pathQuery);
        return q;
    }

    private XPathQuery combineIgnorableQueries(BooleanClause.Occur occur, XPathQuery precursor) {
        if (occur == BooleanClause.Occur.MUST && this.isFact(32) != precursor.isFact(32)) {
            if (this.isFact(32)) {
                if (this.isEmpty() && this.isMinimal()) {
                    return precursor;
                }
                return precursor.setFact(2, false);
            }
            if (precursor.isEmpty() && precursor.isMinimal()) {
                return this;
            }
            return this.setFact(2, false);
        }
        return null;
    }

    private SortField[] combineSortFields(XPathQuery precursor) {
        if (this.sortFields != null) {
            if (precursor.sortFields != null) {
                ArrayList<SortField> combined = new ArrayList<SortField>(Arrays.asList(this.sortFields));
                SortField prevSort = combined.get(combined.size() - 1);
                for (SortField sortField : precursor.sortFields) {
                    if (sortField.equals((Object)prevSort)) continue;
                    combined.add(sortField);
                }
                return combined.toArray(new SortField[combined.size()]);
            }
            return this.sortFields;
        }
        if (precursor.sortFields != null) {
            return precursor.sortFields;
        }
        return null;
    }

    public XPathQuery combineSpanQueries(XPathQuery precursor, BooleanClause.Occur occur, boolean isPredicate, ValueType type, int distance, IndexConfiguration config) {
        ParseableQuery pathCombined;
        XPathQuery result = this.combineIgnorableQueries(occur, precursor);
        if (result != null) {
            return result.setType(type);
        }
        long resultFacts = XPathQuery.combineQueryFacts(this, precursor);
        if (this.pathQuery == null) {
            pathCombined = precursor.pathQuery;
            if (precursor.isFact(128)) {
                resultFacts |= 0x80L;
            }
        } else if (precursor.pathQuery == null) {
            pathCombined = this.pathQuery;
            if (this.isFact(128)) {
                resultFacts |= 0x80L;
            }
        } else {
            pathCombined = XPathQuery.combineSpans(this.pathQuery, occur, precursor.pathQuery, distance);
            resultFacts &= 0xFFFFFFFFFFFFFF7FL;
        }
        ParseableQuery combined = XPathQuery.combineBoolean(this.pquery, occur, precursor.pquery, occur);
        if (isPredicate) {
            combined = XPathQuery.combineBoolean(combined, occur, pathCombined, occur);
            pathCombined = this.pathQuery;
            resultFacts |= 0x80L;
        }
        SortField[] combinedSorts = this.combineSortFields(precursor);
        XPathQuery q = new XPathQuery(combined, resultFacts, type);
        q.setPathQuery(pathCombined);
        q.setSortFields(combinedSorts);
        return q;
    }

    private static long combineQueryFacts(XPathQuery a, XPathQuery b) {
        if (b.isEmpty() && b.isMinimal()) {
            return a.facts;
        }
        if (a.isEmpty() && a.isMinimal()) {
            return b.facts;
        }
        return XPathQuery.combineFacts(a.facts, b.facts);
    }

    private static ParseableQuery combineBoolean(ParseableQuery a, BooleanClause.Occur aOccur, ParseableQuery b, BooleanClause.Occur bOccur) {
        if (a == null || a.equals(b)) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.isMatchAll() && bOccur != BooleanClause.Occur.MUST_NOT) {
            return b;
        }
        if (b.isMatchAll() && aOccur != BooleanClause.Occur.MUST_NOT) {
            return a;
        }
        return new BooleanPQuery(new BooleanPQuery.Clause(a, aOccur), new BooleanPQuery.Clause(b, bOccur));
    }

    private static ParseableQuery combineSpans(ParseableQuery a, BooleanClause.Occur occur, ParseableQuery b, int distance) {
        if (a.isMatchAll() && occur != BooleanClause.Occur.MUST_NOT && (distance > 90 || distance < 0)) {
            if (occur == BooleanClause.Occur.SHOULD) {
                return a;
            }
            return b;
        }
        if (b.isMatchAll()) {
            if (occur == BooleanClause.Occur.SHOULD) {
                return b;
            }
            return a;
        }
        if (distance >= 0) {
            return XPathQuery.combineFiniteSpan(a, occur, b, distance);
        }
        if (a.equals(b)) {
            return a;
        }
        return new SpanBooleanPQuery(occur, a, b);
    }

    private static ParseableQuery combineFiniteSpan(ParseableQuery a, BooleanClause.Occur occur, ParseableQuery b, int distance) {
        if (occur != BooleanClause.Occur.MUST) {
            throw new IllegalArgumentException("unsupported boolean combination for span query: " + occur);
        }
        assert (!(a instanceof SpanBooleanPQuery) || !(b instanceof SpanBooleanPQuery));
        if (a instanceof SpanBooleanPQuery && ((SpanBooleanPQuery)a).getOccur() == BooleanClause.Occur.MUST || b instanceof SpanBooleanPQuery && ((SpanBooleanPQuery)b).getOccur() == BooleanClause.Occur.MUST) {
            return XPathQuery.combineBooleanWithSpan(a, b, distance);
        }
        if (a == MatchAllPQuery.getInstance()) {
            return new SpanNearPQuery(distance, true, SpanMatchAll.getInstance(), b);
        }
        return new SpanNearPQuery(distance, true, a, b);
    }

    private static ParseableQuery combineBooleanWithSpan(ParseableQuery a, ParseableQuery b, int distance) {
        SpanBooleanPQuery bq = (SpanBooleanPQuery)(a instanceof SpanBooleanPQuery ? a : b);
        BooleanPQuery.Clause[] bclauses = bq.getClauses();
        BooleanPQuery.Clause[] clauses = new BooleanPQuery.Clause[bclauses.length];
        for (int i = 0; i < clauses.length; ++i) {
            BooleanPQuery.Clause clause = bclauses[i];
            ParseableQuery query = clause.getQuery();
            clauses[i] = !query.isSpanCompatible() ? clause : (bq == a ? new BooleanPQuery.Clause(new SpanNearPQuery(distance, true, query, b), clause.getOccur()) : new BooleanPQuery.Clause(new SpanNearPQuery(distance, true, a, query), clause.getOccur()));
        }
        return new SpanBooleanPQuery(clauses);
    }

    private static final long combineFacts(long facts2, long facts3) {
        return facts2 & facts3;
    }

    public boolean isEmpty() {
        return this.isFact(64);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.pquery == null ? "" : this.pquery.toString());
        if (this.pathQuery != null) {
            buf.append('{').append(this.pathQuery.toString()).append('}');
        }
        return buf.toString();
    }

    public XPathQuery setFact(int fact, boolean t) {
        XPathQuery query = this;
        if (this.immutable) {
            query = new XPathQuery(this.pquery, this.facts, this.valueType);
        }
        query.facts = t ? (query.facts |= (long)fact) : (query.facts &= (long)(~fact));
        return query;
    }

    public final boolean isFact(int fact) {
        return (this.facts & (long)fact) == (long)fact;
    }

    public long getFacts() {
        return this.facts;
    }

    public XPathQuery setType(ValueType type) {
        if (type == null) {
            type = ValueType.VALUE;
        }
        XPathQuery query = this.immutable ? new XPathQuery(this.pquery, this.facts, type) : this;
        query.valueType = type;
        query.facts &= 0xFFFFFFFFFFFFFFEFL;
        if (query.valueType == ValueType.BOOLEAN) {
            query.facts &= 0xFFFFFFFFFFFFFFFBL;
        } else if (query.valueType == ValueType.DOCUMENT) {
            query.facts |= 4L;
        }
        return query;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public AbstractExpression toXmlNode(String defaultField, IndexConfiguration config) {
        return this.getFullQuery().toXmlNode(defaultField, config);
    }

    public ParseableQuery getBooleanQuery() {
        return this.pquery;
    }

    public ParseableQuery getPathQuery() {
        return this.pathQuery;
    }

    public void setPathQuery(ParseableQuery baseQuery) {
        this.pathQuery = baseQuery;
    }

    public ParseableQuery getFullQuery() {
        ParseableQuery q = this.getBooleanQuery();
        if (this.pathQuery != null && !this.isFact(128)) {
            q = q == null || q.isMatchAll() ? this.pathQuery : new BooleanPQuery(BooleanClause.Occur.MUST, q, this.pathQuery);
        }
        return q;
    }
}

