/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import lux.Evaluator;
import lux.functions.SearchBase;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class DeleteDocument
extends ExtensionFunctionDefinition {
    public StructuredQName getFunctionQName() {
        return new StructuredQName("lux", "http://luxdb.net", "delete");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.EMPTY_SEQUENCE;
    }

    public boolean hasSideEffects() {
        return true;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new DeleteDocumentCall();
    }

    class DeleteDocumentCall
    extends ExtensionFunctionCall {
        DeleteDocumentCall() {
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String uri = arguments[0].head().getStringValue();
            Evaluator eval = SearchBase.getEvaluator(context);
            if (uri.equals("lux:/")) {
                eval.getDocWriter().deleteAll();
            } else {
                eval.getDocWriter().delete(uri);
            }
            return EmptySequence.getInstance();
        }
    }
}

