/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import lux.Evaluator;
import lux.functions.SearchBase;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class InsertDocument
extends ExtensionFunctionDefinition {
    public StructuredQName getFunctionQName() {
        return new StructuredQName("lux", "http://luxdb.net", "insert");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.SINGLE_NODE};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.EMPTY_SEQUENCE;
    }

    public boolean hasSideEffects() {
        return true;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new InsertDocumentCall();
    }

    class InsertDocumentCall
    extends ExtensionFunctionCall {
        InsertDocumentCall() {
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String uri = arguments[0].head().getStringValue();
            NodeInfo node = (NodeInfo)arguments[1].head();
            if (node.getNodeKind() == 3) {
                throw new XPathException("Attempt to insert text node: not supported");
            }
            if (node.getNodeKind() != 9 && node.getNodeKind() != 1) {
                throw new XPathException("Attempt to insert unsupported node type");
            }
            Evaluator eval = SearchBase.getEvaluator(context);
            try {
                eval.getDocWriter().write(node, uri);
            }
            catch (Exception e) {
                throw new XPathException("An error occurred while inserting a document at uri: " + uri + "; " + e.getMessage(), (Throwable)e);
            }
            return EmptySequence.getInstance();
        }
    }
}

