/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import lux.functions.Commit;
import lux.functions.Count;
import lux.functions.DeleteDocument;
import lux.functions.Eval;
import lux.functions.Exists;
import lux.functions.FieldTerms;
import lux.functions.Highlight;
import lux.functions.InsertDocument;
import lux.functions.Key;
import lux.functions.LuxFunctionCall;
import lux.functions.Search;
import lux.functions.SearchBase;
import lux.functions.Transform;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.IntegratedFunctionCall;
import net.sf.saxon.functions.IntegratedFunctionLibrary;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.trans.XPathException;

public class LuxFunctionLibrary
extends IntegratedFunctionLibrary {
    public Expression bind(StructuredQName functionName, int arity, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        IntegratedFunctionCall ifc = (IntegratedFunctionCall)super.bind(functionName, arity, staticArgs, env, container);
        if (ifc == null) {
            return null;
        }
        ExtensionFunctionCall f = ifc.getFunction();
        if (f instanceof SearchBase.SearchCall && staticArgs.length > 1 && staticArgs[1] instanceof Literal && ((Literal)staticArgs[1]).getValue().getStringValue().equals("lux:docid")) {
            LuxFunctionCall fc = new LuxFunctionCall(f);
            fc.setFunctionName(functionName);
            fc.setArguments(staticArgs);
            return fc;
        }
        return ifc;
    }

    public static void registerFunctions(Processor processor) {
        processor.registerExtensionFunction((ExtensionFunctionDefinition)new Search());
        processor.registerExtensionFunction((ExtensionFunctionDefinition)new Count());
        processor.registerExtensionFunction((ExtensionFunctionDefinition)new Exists());
        processor.registerExtensionFunction((ExtensionFunctionDefinition)new FieldTerms());
        processor.registerExtensionFunction((ExtensionFunctionDefinition)new Key());
        processor.registerExtensionFunction((ExtensionFunctionDefinition)new Transform());
        processor.registerExtensionFunction((ExtensionFunctionDefinition)new Eval());
        processor.registerExtensionFunction((ExtensionFunctionDefinition)new InsertDocument());
        processor.registerExtensionFunction((ExtensionFunctionDefinition)new DeleteDocument());
        processor.registerExtensionFunction((ExtensionFunctionDefinition)new Commit());
        processor.registerExtensionFunction((ExtensionFunctionDefinition)new Highlight());
    }
}

