/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import java.util.ArrayList;
import lux.Evaluator;
import lux.QueryContext;
import lux.TransformErrorListener;
import lux.functions.NamespaceAwareFunctionCall;
import lux.solr.SolrQueryContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;
import org.apache.lucene.search.Query;
import org.apache.solr.handler.component.ResponseBuilder;
import org.slf4j.LoggerFactory;

public abstract class SearchBase
extends ExtensionFunctionDefinition {
    protected abstract SequenceIterator<? extends Item> iterate(Query var1, Evaluator var2, String[] var3, int var4) throws XPathException;

    protected abstract SequenceIterator<? extends Item> iterateDistributed(String var1, QueryParser var2, Evaluator var3, String[] var4, int var5) throws XPathException;

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_ITEM};
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new SearchCall();
    }

    public static Evaluator getEvaluator(XPathContext context) {
        TransformErrorListener listener = (TransformErrorListener)context.getController().getErrorListener();
        return (Evaluator)listener.getUserData();
    }

    public class SearchCall
    extends NamespaceAwareFunctionCall {
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ResponseBuilder rb;
            Evaluator eval;
            QueryContext queryContext;
            Item startArg;
            if (arguments.length == 0 || arguments.length > 3) {
                throw new XPathException("wrong number of arguments for " + SearchBase.this.getFunctionQName());
            }
            Item queryArg = arguments[0].head();
            String[] sortCriteria = null;
            if (arguments.length >= 2) {
                ArrayList<String> sortCriteriaColl = new ArrayList<String>();
                Sequence sortArg = arguments[1];
                if (sortArg != null) {
                    SequenceIterator sortArgs = sortArg.iterate();
                    while (sortArgs.next() != null) {
                        sortCriteriaColl.add(sortArgs.current().getStringValue());
                    }
                }
                sortCriteria = sortCriteriaColl.toArray(new String[sortCriteriaColl.size()]);
            }
            int start = 1;
            if (arguments.length >= 3 && (startArg = arguments[2].head()) != null) {
                IntegerValue integerValue = (IntegerValue)startArg;
                if (integerValue.longValue() > Integer.MAX_VALUE) {
                    throw new XPathException("integer overflow in search $start parameter");
                }
                start = (int)integerValue.longValue();
            }
            if ((queryContext = (eval = SearchBase.getEvaluator(context)).getQueryContext()) instanceof SolrQueryContext && (rb = ((SolrQueryContext)queryContext).getResponseBuilder()) != null && rb.shards != null) {
                String qstr;
                QueryParser qp;
                if (queryArg instanceof NodeInfo) {
                    qp = QueryParser.XML;
                    qstr = new XdmNode((NodeInfo)queryArg).toString();
                } else {
                    qp = QueryParser.CLASSIC;
                    qstr = queryArg.getStringValue();
                }
                return new LazySequence(SearchBase.this.iterateDistributed(qstr, qp, eval, sortCriteria, start));
            }
            Query query = this.parseQuery(queryArg, eval);
            LoggerFactory.getLogger(SearchBase.class).debug("executing query: {}", (Object)query);
            return new LazySequence(SearchBase.this.iterate(query, eval, sortCriteria, start));
        }
    }

    public static enum QueryParser {
        CLASSIC,
        XML;

    }
}

