/*
 * Decompiled with CFR 0.152.
 */
package lux.index;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lux.index.FieldRole;
import lux.index.MultiFieldAnalyzer;
import lux.index.analysis.DefaultAnalyzer;
import lux.index.analysis.ElementVisibility;
import lux.index.analysis.XmlTokenStreamBase;
import lux.index.field.AttributeQNameField;
import lux.index.field.AttributeTextField;
import lux.index.field.DocumentField;
import lux.index.field.ElementQNameField;
import lux.index.field.ElementTextField;
import lux.index.field.FieldDefinition;
import lux.index.field.IDField;
import lux.index.field.PathField;
import lux.index.field.PathOccurrenceField;
import lux.index.field.PathValueField;
import lux.index.field.QNameValueField;
import lux.index.field.TinyBinaryField;
import lux.index.field.TinyBinarySolrField;
import lux.index.field.URIField;
import lux.index.field.XmlTextField;
import net.sf.saxon.s9api.QName;
import org.apache.lucene.util.Version;

public class IndexConfiguration {
    public static final Version LUCENE_VERSION = Version.LUCENE_46;
    public static final int BUILD_DOCUMENT = 1;
    public static final int SOLR = 2;
    public static final int NAMESPACE_AWARE = 4;
    public static final int STORE_DOCUMENT = 8;
    public static final int STORE_TINY_BINARY = 16;
    public static final int INDEX_QNAMES = 32;
    public static final int INDEX_PATHS = 64;
    public static final int INDEX_FULLTEXT = 128;
    public static final int INDEX_VALUES = 256;
    public static final int COMPUTE_OFFSETS = 512;
    public static final int STRIP_NAMESPACES = 1024;
    public static final int INDEX_EACH_PATH = 2048;
    public static final int INDEXES = 480;
    public static final int DEFAULT_OPTIONS = 236;
    public final FieldDefinition URI = new URIField();
    private final FieldDefinition XML_STORE = new DocumentField();
    private final FieldDefinition TINY_BINARY_STORE = new TinyBinaryField();
    private final FieldDefinition ELT_QNAME = new ElementQNameField();
    private final FieldDefinition ATT_QNAME = new AttributeQNameField();
    private final FieldDefinition PATH = new PathField();
    private final FieldDefinition ELEMENT_TEXT = new ElementTextField();
    private final FieldDefinition ATTRIBUTE_TEXT = new AttributeTextField();
    private final FieldDefinition XML_TEXT = new XmlTextField();
    private final FieldDefinition PATH_VALUE = new PathValueField();
    private final FieldDefinition QNAME_VALUE = new QNameValueField();
    private long options;
    private final HashMap<FieldRole, FieldDefinition> fieldsByRole;
    private final HashMap<String, FieldDefinition> fieldsByName;
    private MultiFieldAnalyzer fieldAnalyzers;
    private final HashMap<String, String> namespaceMap = new HashMap();
    private HashMap<QName, ElementVisibility> eltVis;
    private ElementVisibility defVis;

    public MultiFieldAnalyzer getFieldAnalyzers() {
        return this.fieldAnalyzers;
    }

    public IndexConfiguration(long options) {
        this.fieldsByRole = new HashMap();
        this.fieldsByName = new HashMap();
        this.fieldAnalyzers = new MultiFieldAnalyzer();
        this.fieldAnalyzers.put(null, new DefaultAnalyzer());
        this.eltVis = new HashMap();
        this.defVis = ElementVisibility.OPAQUE;
        this.addField(this.URI);
        this.options = options | 4L;
        this.init();
    }

    public IndexConfiguration() {
        this(236L);
    }

    private void init() {
        if (this.isOption(32)) {
            this.addField(this.ELT_QNAME);
            this.addField(this.ATT_QNAME);
            if (this.isOption(256)) {
                this.addField(this.QNAME_VALUE);
            }
        }
        if (this.isOption(64)) {
            if (this.isOption(2048)) {
                this.addField(new PathOccurrenceField());
            } else {
                this.addField(this.PATH);
            }
            if (this.isOption(256)) {
                this.addField(this.PATH_VALUE);
            }
        }
        if (this.isOption(128)) {
            this.addField(this.XML_TEXT);
            if (this.isOption(32) || this.isOption(64)) {
                this.addField(this.ELEMENT_TEXT);
                this.addField(this.ATTRIBUTE_TEXT);
            }
        }
        if (this.isOption(8)) {
            if (this.isOption(16)) {
                if (this.isOption(2)) {
                    this.addField(new TinyBinarySolrField());
                } else {
                    this.addField(this.TINY_BINARY_STORE);
                }
            } else {
                this.addField(this.XML_STORE);
            }
        }
        this.addField(new IDField());
    }

    public void addField(FieldDefinition field) {
        FieldRole role = field.getFieldRole();
        FieldDefinition existing = null;
        if (role != null) {
            existing = this.fieldsByRole.get((Object)role);
        }
        if (existing == null) {
            existing = this.fieldsByName.get(field.getName());
        }
        if (existing != null) {
            if (existing != field) {
                throw new IllegalStateException("Duplicate field name: " + field);
            }
            return;
        }
        if (role != null) {
            this.fieldsByRole.put(role, field);
        }
        this.fieldsByName.put(field.getName(), field);
        this.fieldAnalyzers.put(field.getName(), field.getAnalyzer());
    }

    public String getFieldName(FieldRole role) {
        FieldDefinition field = this.fieldsByRole.get((Object)role);
        if (field == null) {
            return "";
        }
        return field.getName();
    }

    public void renameField(FieldDefinition field, String name) {
        if (!field.isRenameable()) {
            throw new IllegalArgumentException("Attempt to rename field " + field + " whose name is fixed");
        }
        String currentName = field.getName();
        if (currentName.equals(name)) {
            return;
        }
        field.setName(name);
        this.fieldsByName.remove(currentName);
        this.fieldsByName.put(name, field);
    }

    public Collection<FieldDefinition> getFields() {
        return this.fieldsByName.values();
    }

    public FieldDefinition getField(FieldRole fieldName) {
        return this.fieldsByRole.get((Object)fieldName);
    }

    public FieldDefinition getField(String fieldName) {
        return this.fieldsByName.get(fieldName);
    }

    public String getDefaultFieldName() {
        FieldDefinition textField = this.fieldsByRole.get((Object)FieldRole.XML_TEXT);
        if (textField != null) {
            return textField.getName();
        }
        return "";
    }

    public boolean isOption(int option) {
        return (this.options & (long)option) != 0L;
    }

    public boolean isIndexingEnabled() {
        return (this.options & 0x1E0L) != 0L;
    }

    public Map<String, String> getNamespaceMap() {
        return Collections.unmodifiableMap(this.namespaceMap);
    }

    public void defineNamespaceMapping(String prefix, String namespaceURI) {
        this.namespaceMap.put(prefix, namespaceURI);
    }

    public String getUriFieldName() {
        return this.URI.getName();
    }

    public String getXmlFieldName() {
        return this.XML_STORE.getName();
    }

    public String getTextFieldName() {
        return this.XML_TEXT.getName();
    }

    public String getElementTextFieldName() {
        return this.ELEMENT_TEXT.getName();
    }

    public String getAttributeTextFieldName() {
        return this.ATTRIBUTE_TEXT.getName();
    }

    public ElementVisibility getElementVisibility(String clarkName) {
        return this.eltVis.get(QName.fromClarkName((String)clarkName));
    }

    public void setElementVisibility(String clarkName, ElementVisibility vis) {
        this.eltVis.put(QName.fromClarkName((String)clarkName), vis);
    }

    public ElementVisibility getDefaultVisibility() {
        return this.defVis;
    }

    public void configureElementVisibility(XmlTokenStreamBase tokens) {
        tokens.setDefaultVisibility(this.defVis);
        for (Map.Entry<QName, ElementVisibility> entry : this.eltVis.entrySet()) {
            tokens.setElementVisibility(entry.getKey(), entry.getValue());
        }
    }
}

