/*
 * Decompiled with CFR 0.152.
 */
package lux.index;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import lux.Compiler;
import lux.exception.LuxException;
import lux.index.IndexConfiguration;
import lux.index.XPathValueMapper;
import lux.index.XmlPathMapper;
import lux.index.field.FieldDefinition;
import lux.xml.OffsetDocBuilder;
import lux.xml.SaxonDocBuilder;
import lux.xml.Serializer;
import lux.xml.XmlReader;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;

public class XmlIndexer {
    private final IndexConfiguration configuration;
    private XmlReader xmlReader;
    private Processor processor;
    private XPathCompiler compiler;
    private SaxonDocBuilder saxonBuilder;
    private Serializer serializer;
    private XmlPathMapper pathMapper;
    private String uri;
    private byte[] documentBytes;
    private XdmNode xdmNode;
    private HashMap<String, XPathExecutable> xpathCache;

    public XmlIndexer() {
        this(new IndexConfiguration());
    }

    public XmlIndexer(IndexConfiguration config) {
        this.configuration = config;
        this.xpathCache = new HashMap();
        this.init();
    }

    public XmlIndexer(long options) {
        this(new IndexConfiguration(options));
    }

    public XmlIndexer(IndexConfiguration indexConfig, Compiler compiler) {
        this.configuration = indexConfig;
        this.xpathCache = new HashMap();
        this.processor = compiler.getProcessor();
        this.compiler = null;
        this.init();
    }

    protected void init() {
        this.xmlReader = new XmlReader();
        if (this.isOption(32) || this.isOption(64)) {
            this.pathMapper = this.isOption(256) ? new XPathValueMapper() : new XmlPathMapper();
            this.pathMapper.setNamespaceAware(this.isOption(4));
            this.xmlReader.addHandler(this.pathMapper);
        }
        if (this.isOption(128)) {
            this.initDocBuilder();
        }
        if (this.isOption(8) && !this.isOption(16)) {
            this.serializer = new Serializer();
            this.xmlReader.addHandler(this.serializer);
        }
        if (this.isOption(1) && this.saxonBuilder == null) {
            this.initDocBuilder();
        }
        if (this.isOption(1024)) {
            this.xmlReader.setStripNamespaces(true);
        }
    }

    public IndexWriter newIndexWriter(Directory dir) throws IOException {
        return new IndexWriter(dir, new IndexWriterConfig(IndexConfiguration.LUCENE_VERSION, (Analyzer)this.configuration.getFieldAnalyzers()));
    }

    public XPathCompiler getXPathCompiler() {
        if (this.compiler == null) {
            this.compiler = this.getProcessor().newXPathCompiler();
            for (Map.Entry<String, String> nsmap : this.configuration.getNamespaceMap().entrySet()) {
                this.compiler.declareNamespace(nsmap.getKey(), nsmap.getValue());
            }
        }
        return this.compiler;
    }

    private Processor getProcessor() {
        if (this.processor == null) {
            this.processor = new Processor(false);
        }
        return this.processor;
    }

    public XdmValue evaluateXPath(String xpath) throws SaxonApiException {
        XPathExecutable xpathExec = this.xpathCache.get(xpath);
        if (xpathExec == null) {
            xpathExec = this.getXPathCompiler().compile(xpath);
            this.xpathCache.put(xpath, xpathExec);
        }
        XPathSelector xps = xpathExec.load();
        xps.setContextItem((XdmItem)this.getXdmNode());
        return xps.evaluate();
    }

    private void initDocBuilder() {
        try {
            this.saxonBuilder = this.isOption(512) ? new OffsetDocBuilder(this.getProcessor()) : new SaxonDocBuilder(this.getProcessor());
            this.xmlReader.addHandler(this.saxonBuilder);
        }
        catch (SaxonApiException e) {
            throw new LuxException(e);
        }
    }

    public void index(InputStream xml, String inputUri) throws XMLStreamException {
        this.reset();
        this.uri = inputUri;
        this.xmlReader.read(xml);
        this.xdmNode = this.getBuilderNode();
    }

    public void index(Reader xml, String inputUri) throws XMLStreamException {
        this.reset();
        this.uri = inputUri;
        this.xmlReader.read(xml);
        this.xdmNode = this.getBuilderNode();
    }

    public void index(NodeInfo doc, String inputUri) throws XMLStreamException {
        this.reset();
        this.uri = inputUri;
        this.xmlReader.read(doc);
        this.xdmNode = this.getBuilderNode();
    }

    public void reset() {
        this.xmlReader.reset();
        this.uri = null;
        this.xdmNode = null;
        this.documentBytes = null;
    }

    private boolean isOption(int option) {
        return this.configuration.isOption(option);
    }

    private Collection<FieldDefinition> getFields() {
        return this.configuration.getFields();
    }

    public String getURI() {
        return this.uri;
    }

    public XdmNode getXdmNode() {
        return this.xdmNode;
    }

    private XdmNode getBuilderNode() {
        if (this.saxonBuilder == null) {
            return null;
        }
        try {
            return this.saxonBuilder.getDocument();
        }
        catch (SaxonApiException e) {
            throw new LuxException(e);
        }
    }

    public String getDocumentText() {
        if (this.serializer != null) {
            return this.serializer.getDocument();
        }
        return null;
    }

    public byte[] getDocumentBytes() {
        return this.documentBytes;
    }

    public void indexDocument(IndexWriter indexWriter, String docUri, String xml) throws XMLStreamException, IOException {
        this.reset();
        String path = XmlIndexer.normalizeUri(docUri);
        this.index(new StringReader(xml), path);
        this.addLuceneDocument(indexWriter);
    }

    public void indexDocument(IndexWriter indexWriter, String docUri, InputStream xmlStream) throws XMLStreamException, IOException {
        this.reset();
        String path = XmlIndexer.normalizeUri(docUri);
        this.index(xmlStream, path);
        this.addLuceneDocument(indexWriter);
    }

    public void storeDocument(IndexWriter indexWriter, String docUri, InputStream input) throws IOException {
        this.storeDocument(indexWriter, docUri, IOUtils.toByteArray((InputStream)input));
    }

    public void storeDocument(IndexWriter indexWriter, String docUri, byte[] bytes) throws IOException {
        String path;
        this.reset();
        this.uri = path = XmlIndexer.normalizeUri(docUri);
        this.documentBytes = bytes;
        this.addLuceneDocument(indexWriter);
    }

    private static String normalizeUri(String uri) {
        String path = uri.replaceFirst("^\\w+:/+", "/");
        path = path.replace('\\', '/');
        return path;
    }

    public void indexDocument(IndexWriter indexWriter, String path, NodeInfo node) throws XMLStreamException, IOException {
        this.reset();
        this.index(node, path);
        this.addLuceneDocument(indexWriter);
    }

    public Document createLuceneDocument() {
        Document doc = new Document();
        for (FieldDefinition field : this.getFields()) {
            for (IndexableField indexableField : field.getFieldValues(this)) {
                doc.add(indexableField);
            }
        }
        return doc;
    }

    private void addLuceneDocument(IndexWriter indexWriter) throws CorruptIndexException, IOException {
        indexWriter.deleteDocuments(new Term(this.configuration.getUriFieldName(), this.uri));
        indexWriter.addDocument((Iterable)this.createLuceneDocument());
    }

    public SaxonDocBuilder getSaxonDocBuilder() {
        return this.saxonBuilder;
    }

    public XmlPathMapper getPathMapper() {
        return this.pathMapper;
    }

    public IndexConfiguration getConfiguration() {
        return this.configuration;
    }
}

