/*
 * Decompiled with CFR 0.152.
 */
package lux.index.analysis;

import lux.index.analysis.AncestorIterator;
import lux.index.analysis.ContentIterator;
import lux.index.analysis.ElementVisibility;
import lux.index.analysis.QNameTokenFilter;
import lux.index.analysis.TextOffsetTokenStream;
import lux.index.attribute.QNameAttribute;
import lux.xml.Offsets;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

public final class ElementTokenStream
extends TextOffsetTokenStream {
    private final QNameAttribute qnameAtt;
    private QNameTokenFilter qnameTokenFilter = new QNameTokenFilter(this.getWrappedTokenStream());

    public ElementTokenStream(String fieldName, Analyzer analyzer, TokenStream wrapped, XdmNode doc, Offsets offsets) {
        super(fieldName, analyzer, wrapped, doc, offsets);
        this.contentIter = new ContentIterator(doc);
        this.qnameAtt = (QNameAttribute)this.qnameTokenFilter.addAttribute(QNameAttribute.class);
        this.setWrappedTokenStream((TokenStream)this.qnameTokenFilter);
    }

    @Override
    protected boolean updateNodeAtts() {
        this.getAncestorQNames();
        return this.qnameAtt.hasNext();
    }

    private void getAncestorQNames() {
        assert (this.curNode.getNodeKind() == XdmNodeKind.TEXT);
        AncestorIterator nodeAncestors = new AncestorIterator(this.curNode);
        this.qnameAtt.clearQNames();
        boolean isOpaque = false;
        while (nodeAncestors.hasNext()) {
            XdmNode e = (XdmNode)nodeAncestors.next();
            assert (e.getNodeKind() == XdmNodeKind.ELEMENT);
            QName qname = e.getNodeName();
            ElementVisibility vis = (ElementVisibility)((Object)this.eltVis.get(qname));
            if (vis == null) {
                vis = this.defVis;
            }
            if (vis == ElementVisibility.HIDDEN) {
                return;
            }
            if (isOpaque) {
                if (vis != ElementVisibility.CONTAINER) continue;
                this.qnameAtt.addQName(new lux.xml.QName(qname.getNamespaceURI(), qname.getLocalName(), qname.getPrefix()));
                continue;
            }
            this.qnameAtt.addQName(new lux.xml.QName(qname.getNamespaceURI(), qname.getLocalName(), qname.getPrefix()));
            if (vis != ElementVisibility.OPAQUE && vis != ElementVisibility.CONTAINER) continue;
            isOpaque = true;
        }
    }
}

