/*
 * Decompiled with CFR 0.152.
 */
package lux.index.analysis;

import java.io.IOException;
import lux.index.analysis.CharSequenceStream;
import lux.index.analysis.OffsetCharFilter;
import lux.index.analysis.XmlTokenStreamBase;
import lux.xml.Offsets;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

public abstract class TextOffsetTokenStream
extends XmlTokenStreamBase {
    private int iText;
    private int iDelta;
    private Offsets offsets;
    private CharSequenceStream charSequenceStream;

    public TextOffsetTokenStream(String fieldName, Analyzer analyzer, TokenStream wrapped, XdmNode doc, Offsets offsets) {
        super(fieldName, analyzer, wrapped);
        this.offsets = offsets;
        this.iText = 0;
        this.iDelta = 0;
    }

    @Override
    protected boolean resetTokenizer(CharSequence text) {
        this.charSequenceStream = new CharSequenceStream(text);
        OffsetCharFilter offsetCharFilter = null;
        if (this.offsets != null) {
            offsetCharFilter = new OffsetCharFilter(this.charSequenceStream);
            this.charStream = offsetCharFilter;
            this.updateOffsets(offsetCharFilter, text.length());
        } else {
            this.charStream = this.charSequenceStream;
        }
        try {
            this.reset();
            return this.incrementWrappedTokenStream();
        }
        catch (IOException e) {
            return false;
        }
    }

    private void updateOffsets(OffsetCharFilter offsetCharFilter, int length) {
        if (this.curNode.getNodeKind() == XdmNodeKind.TEXT && this.offsets != null) {
            int dOff;
            int location = this.offsets.getTextLocation(this.iText++);
            offsetCharFilter.addOffset(0, location);
            int deltaLocation = this.offsets.getDeltaLocation(this.iDelta);
            while (this.iDelta < this.offsets.getDeltaCount() && deltaLocation < location) {
                deltaLocation = this.offsets.getDeltaLocation(++this.iDelta);
            }
            while (this.iDelta < this.offsets.getDeltaCount() && (dOff = deltaLocation - (location += this.offsets.getDelta(this.iDelta))) <= length) {
                offsetCharFilter.addOffset(dOff, location);
                deltaLocation = this.offsets.getDeltaLocation(++this.iDelta);
            }
        }
    }
}

