/*
 * Decompiled with CFR 0.152.
 */
package lux.index.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import lux.index.analysis.ElementVisibility;
import lux.index.analysis.EmptyXdmIterator;
import lux.index.analysis.OffsetCharFilter;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.AttributeSource;

public abstract class XmlTokenStreamBase
extends TokenStream {
    private final String fieldName;
    private final Analyzer analyzer;
    private TokenStream wrapped;
    protected XdmNode curNode;
    protected Iterator<XdmNode> contentIter;
    protected CharTermAttribute termAtt;
    protected Reader charStream = new OffsetCharFilter(new StringReader(""));
    protected ElementVisibility defVis;
    protected HashMap<QName, ElementVisibility> eltVis;
    protected static final XdmSequenceIterator EMPTY = new EmptyXdmIterator(null);

    XmlTokenStreamBase(String fieldName, Analyzer analyzer, TokenStream wrapped) {
        super((AttributeSource)wrapped);
        this.wrapped = wrapped;
        this.fieldName = fieldName;
        this.analyzer = analyzer;
        this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.defVis = ElementVisibility.OPAQUE;
        this.eltVis = new HashMap();
    }

    public void reset() throws IOException {
        this.reset(this.charStream);
        this.wrapped.reset();
    }

    public void close() throws IOException {
        this.wrapped.close();
    }

    public void reset(Reader reader) throws IOException {
        this.close();
        TokenStream reset = this.analyzer.tokenStream(this.fieldName, reader);
        assert (reset.getAttribute(CharTermAttribute.class) == this.wrapped.getAttribute(CharTermAttribute.class));
    }

    public boolean incrementToken() throws IOException {
        return this.incrementWrappedTokenStream() || this.advanceToTokenNode();
    }

    public TokenStream getWrappedTokenStream() {
        return this.wrapped;
    }

    protected void setWrappedTokenStream(TokenStream wrapped) {
        this.wrapped = wrapped;
    }

    protected boolean incrementWrappedTokenStream() throws IOException {
        while (this.wrapped.incrementToken()) {
            if (this.termAtt.length() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean advanceToTokenNode() {
        while (this.contentIter.hasNext()) {
            this.curNode = this.contentIter.next();
            NodeInfo nodeInfo = this.curNode.getUnderlyingNode();
            if (!this.updateNodeAtts() || !this.resetTokenizer(nodeInfo.getStringValueCS())) continue;
            return true;
        }
        return false;
    }

    abstract boolean resetTokenizer(CharSequence var1);

    abstract boolean updateNodeAtts();

    public ElementVisibility getElementVisibility(QName qname) {
        return this.eltVis.get(qname);
    }

    public void setElementVisibility(QName qname, ElementVisibility vis) {
        this.eltVis.put(qname, vis);
    }

    public ElementVisibility getDefaultVisibility() {
        return this.defVis;
    }

    public void setDefaultVisibility(ElementVisibility vis) {
        this.defVis = vis;
    }
}

